/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorListener;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.util.Declarations;
import com.sun.mirror.util.Types;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.core.env.Phase;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.AptProject;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.PackageDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.PackageDeclarationImplNoBinding;
import org.eclipse.jdt.apt.core.internal.declaration.TypeDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.type.PrimitiveTypeImpl;
import org.eclipse.jdt.apt.core.internal.type.VoidTypeImpl;
import org.eclipse.jdt.apt.core.internal.util.DeclarationsUtil;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.apt.core.internal.util.PackageUtil;
import org.eclipse.jdt.apt.core.internal.util.TypesUtil;
import org.eclipse.jdt.apt.core.internal.util.Visitors;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class BaseProcessorEnv
implements AnnotationProcessorEnvironment {
    private static final int JLS_LATEST = 14;
    public static final CompilationUnit EMPTY_AST_UNIT;
    public static final ICompilationUnit[] NO_UNIT;
    public static final CompilationUnit[] NO_AST_UNITs;
    public static final String[] NO_KEYS;
    private static final int BOOLEAN_INDEX = 0;
    private static final int BYTE_INDEX = 1;
    private static final int CHAR_INDEX = 2;
    private static final int DOUBLE_INDEX = 3;
    private static final int FLOAT_INDEX = 4;
    private static final int INT_INDEX = 5;
    private static final int LONG_INDEX = 6;
    private static final int SHORT_INDEX = 7;
    private static final String DOT_JAVA = ".java";
    protected CompilationUnit _astRoot;
    protected final Phase _phase;
    protected IFile _file;
    protected final IJavaProject _javaProject;
    protected final AptProject _aptProject;
    private final boolean _isTestCode;
    protected final Map<String, String> _options;
    protected final Map<ICompilationUnit, CompilationUnit> _modelCompUnit2astCompUnit;
    protected final Map<ITypeBinding, ICompilationUnit> _typeBinding2ModelCompUnit;
    private VoidTypeImpl _voidType;
    private PrimitiveTypeImpl[] _primitives;
    protected final Map<String, TypeDeclaration> _typeCache = new HashMap<String, TypeDeclaration>();
    protected IPackageFragmentRoot[] _packageRootsCache;

    static {
        AST ast = AST.newAST((int)14, (boolean)true);
        EMPTY_AST_UNIT = ast.newCompilationUnit();
        NO_UNIT = new ICompilationUnit[0];
        NO_AST_UNITs = new CompilationUnit[0];
        NO_KEYS = new String[0];
    }

    public BaseProcessorEnv(CompilationUnit astCompilationUnit, IFile file, IJavaProject javaProj, Phase phase, boolean isTestCode) {
        this._astRoot = astCompilationUnit;
        this._file = file;
        this._javaProject = javaProj;
        this._phase = phase;
        this._options = this.initOptions(javaProj);
        this._modelCompUnit2astCompUnit = new HashMap<ICompilationUnit, CompilationUnit>();
        this._typeBinding2ModelCompUnit = new HashMap<ITypeBinding, ICompilationUnit>();
        this._aptProject = AptPlugin.getAptProject(javaProj);
        this._isTestCode = isTestCode;
    }

    private Map<String, String> initOptions(IJavaProject jproj) {
        Map<String, String> procOptions = AptConfig.getProcessorOptions(jproj, this.isTestCode());
        HashMap<String, String> options = new HashMap<String, String>(procOptions.size() * 2);
        for (Map.Entry<String, String> entry : procOptions.entrySet()) {
            String value = entry.getValue();
            String key = entry.getKey();
            options.put(key, value);
            if (AptConfig.isAutomaticProcessorOption(key)) continue;
            String sunStyle = value != null ? "-A" + entry.getKey() + "=" + value : "-A" + entry.getKey();
            options.put(sunStyle, "");
        }
        return Collections.unmodifiableMap(options);
    }

    @Override
    public Types getTypeUtils() {
        return new TypesUtil(this);
    }

    @Override
    public Declarations getDeclarationUtils() {
        return new DeclarationsUtil();
    }

    @Override
    public void addListener(AnnotationProcessorListener listener) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public void removeListener(AnnotationProcessorListener listener) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public Collection<TypeDeclaration> getTypeDeclarations() {
        List<ITypeBinding> bindings = this.getTypeBindings();
        if (bindings.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TypeDeclaration> mirrorDecls = new ArrayList<TypeDeclaration>(bindings.size());
        for (ITypeBinding binding : bindings) {
            TypeDeclarationImpl mirrorDecl = Factory.createReferenceType(binding, this);
            if (mirrorDecl == null) continue;
            mirrorDecls.add(mirrorDecl);
        }
        return mirrorDecls;
    }

    protected List<AbstractTypeDeclaration> searchLocallyForTypeDeclarations() {
        return this._astRoot.types();
    }

    private List<ITypeBinding> getTypeBindings() {
        List<AbstractTypeDeclaration> declTypes = this.searchLocallyForTypeDeclarations();
        if (declTypes == null || declTypes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ITypeBinding> typeBindings = new ArrayList<ITypeBinding>(declTypes.size());
        for (AbstractTypeDeclaration decl : declTypes) {
            this.getTypeBindings(decl.resolveBinding(), typeBindings);
        }
        return typeBindings;
    }

    protected void getTypeBindings(ITypeBinding type, List<ITypeBinding> typeBindings) {
        if (type == null) {
            return;
        }
        typeBindings.add(type);
        ITypeBinding[] iTypeBindingArray = type.getDeclaredTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding nestedType = iTypeBindingArray[n2];
            this.getTypeBindings(nestedType, typeBindings);
            ++n2;
        }
    }

    @Override
    public Collection<TypeDeclaration> getSpecifiedTypeDeclarations() {
        return this.getTypeDeclarations();
    }

    @Override
    public Collection<Declaration> getDeclarationsAnnotatedWith(AnnotationTypeDeclaration a) {
        ITypeBinding annotationType = TypesUtil.getTypeBinding(a);
        if (annotationType == null || !annotationType.isAnnotation()) {
            return Collections.emptyList();
        }
        return this.getDeclarationsAnnotatedWith(annotationType);
    }

    protected Map<ASTNode, List<Annotation>> getASTNodesWithAnnotations() {
        HashMap<ASTNode, List<Annotation>> astNode2Anno = new HashMap<ASTNode, List<Annotation>>();
        Visitors.AnnotatedNodeVisitor visitor = new Visitors.AnnotatedNodeVisitor(astNode2Anno);
        this._astRoot.accept((ASTVisitor)visitor);
        return astNode2Anno;
    }

    private List<Declaration> getDeclarationsAnnotatedWith(ITypeBinding annotationType) {
        Map<ASTNode, List<Annotation>> astNode2Anno = this.getASTNodesWithAnnotations();
        if (astNode2Anno.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Declaration> decls = new ArrayList<Declaration>();
        for (Map.Entry<ASTNode, List<Annotation>> entry : astNode2Anno.entrySet()) {
            ASTNode node = entry.getKey();
            for (Annotation anno : entry.getValue()) {
                ITypeBinding resolvedTypeBinding = anno.resolveTypeBinding();
                if (!annotationType.isEqualTo((IBinding)resolvedTypeBinding)) continue;
                this.getDeclarations(node, decls);
            }
        }
        return decls;
    }

    protected IFile getFileForNode(ASTNode node) {
        if (node.getRoot() == this._astRoot) {
            return this._file;
        }
        throw new IllegalStateException();
    }

    protected void getDeclarations(ASTNode node, List<Declaration> decls) {
        if (node == null) {
            return;
        }
        IVariableBinding binding = null;
        switch (node.getNodeType()) {
            case 23: {
                List fragments = ((FieldDeclaration)node).fragments();
                for (VariableDeclarationFragment frag : fragments) {
                    IVariableBinding fieldBinding = frag.resolveBinding();
                    EclipseDeclarationImpl decl = fieldBinding != null ? Factory.createDeclaration((IBinding)fieldBinding, this) : Factory.createDeclaration((ASTNode)frag, this.getFileForNode((ASTNode)frag), this);
                    if (decl == null) continue;
                    decls.add(decl);
                }
                return;
            }
            case 72: {
                binding = ((EnumConstantDeclaration)node).resolveVariable();
                break;
            }
            case 31: {
                binding = ((MethodDeclaration)node).resolveBinding();
                break;
            }
            case 82: {
                binding = ((AnnotationTypeMemberDeclaration)node).resolveBinding();
                break;
            }
            case 55: 
            case 71: 
            case 81: {
                binding = ((AbstractTypeDeclaration)node).resolveBinding();
                break;
            }
            case 44: {
                break;
            }
            case 35: {
                binding = ((PackageDeclaration)node).resolveBinding();
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown node type: " + node.getNodeType());
            }
        }
        EclipseDeclarationImpl decl = binding != null ? Factory.createDeclaration((IBinding)binding, this) : Factory.createDeclaration(node, this.getFileForNode(node), this);
        if (decl != null) {
            decls.add(decl);
        }
    }

    public ASTNode getASTNodeForBinding(IBinding binding) {
        CompilationUnit astUnit = this.getCompilationUnitForBinding(binding);
        if (astUnit == null) {
            return null;
        }
        return astUnit.findDeclaringNode(binding.getKey());
    }

    @Override
    public Map<String, String> getOptions() {
        return this._options;
    }

    @Override
    public TypeDeclaration getTypeDeclaration(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        int index = name.indexOf(60);
        if (index != -1) {
            name = name.substring(0, index);
        }
        ITypeBinding typeBinding = null;
        try {
            typeBinding = this.getTypeDefinitionBindingFromName(name);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            AptPlugin.log(e, "Unable to get type definition binding for: " + name);
        }
        return Factory.createReferenceType(typeBinding, this);
    }

    protected ITypeBinding getTypeDefinitionBindingFromCorrectName(String fullyQualifiedName) {
        int dollarIndex = fullyQualifiedName.indexOf(36);
        String toplevelTypeName = dollarIndex < 0 ? fullyQualifiedName : fullyQualifiedName.substring(0, dollarIndex);
        ICompilationUnit unit = this.getICompilationUnitForTopLevelType(toplevelTypeName);
        String key = BindingKey.createTypeBindingKey((String)fullyQualifiedName);
        return (ITypeBinding)this.getBindingFromKey(key, unit);
    }

    private ITypeBinding getTypeDefinitionBindingFromName(String fullyQualifiedName) {
        ITypeBinding binding = this.getTypeDefinitionBindingFromCorrectName(fullyQualifiedName);
        while (binding == null) {
            int dotIndex = fullyQualifiedName.lastIndexOf(46);
            if (dotIndex == -1) break;
            fullyQualifiedName = String.valueOf(fullyQualifiedName.substring(0, dotIndex)) + "$" + fullyQualifiedName.substring(dotIndex + 1);
            binding = this.getTypeDefinitionBindingFromCorrectName(fullyQualifiedName);
        }
        return binding;
    }

    protected IBinding getBindingFromKey(String key, ICompilationUnit unit) {
        ICompilationUnit[] iCompilationUnitArray;
        class BindingRequestor
        extends ASTRequestor {
            private IBinding _result = null;
            private int _kind;
            private final /* synthetic */ ICompilationUnit val$unit;

            BindingRequestor(ICompilationUnit iCompilationUnit) {
                this.val$unit = iCompilationUnit;
            }

            public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
                if (source == this.val$unit) {
                    BaseProcessorEnv.this._modelCompUnit2astCompUnit.put(source, ast);
                }
            }

            public void acceptBinding(String bindingKey, IBinding binding) {
                if (binding != null) {
                    this._result = binding;
                    this._kind = binding.getKind();
                }
            }
        }
        BindingRequestor requestor = new BindingRequestor(unit);
        ASTParser parser = ASTParser.newParser((int)14);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        parser.setProject(this._javaProject);
        parser.setIgnoreMethodBodies(true);
        if (unit == null) {
            iCompilationUnitArray = NO_UNIT;
        } else {
            ICompilationUnit[] iCompilationUnitArray2 = new ICompilationUnit[1];
            iCompilationUnitArray = iCompilationUnitArray2;
            iCompilationUnitArray2[0] = unit;
        }
        ICompilationUnit[] units = iCompilationUnitArray;
        parser.createASTs(units, new String[]{key}, (ASTRequestor)requestor, null);
        IBinding result = requestor._result;
        if (result != null && unit != null) {
            CompilationUnit astUnit = this._modelCompUnit2astCompUnit.get(unit);
            if (requestor._kind == 2 && astUnit.findDeclaringNode(result) != null) {
                ITypeBinding declaringClass = BaseProcessorEnv.getDeclaringClass(result);
                this._typeBinding2ModelCompUnit.put(declaringClass, unit);
            }
        }
        return result;
    }

    public ITypeBinding getTypeBindingFromKey(String key) {
        return (ITypeBinding)this.getBindingFromKey(key, null);
    }

    public TypeDeclaration getTypeDeclaration(IType type) {
        if (type == null) {
            return null;
        }
        String name = type.getFullyQualifiedName();
        return this.getTypeDeclaration(name);
    }

    @Override
    public com.sun.mirror.declaration.PackageDeclaration getPackage(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        IPackageFragment[] pkgFrags = PackageUtil.getPackageFragments(name, this);
        if (pkgFrags.length == 0) {
            return null;
        }
        try {
            String key;
            IPackageBinding packageBinding;
            boolean containsNoJavaResources = true;
            IPackageFragment[] iPackageFragmentArray = pkgFrags;
            int n = pkgFrags.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment pkg = iPackageFragmentArray[n2];
                if (pkg.containsJavaResources()) {
                    containsNoJavaResources = false;
                    break;
                }
                ++n2;
            }
            if (containsNoJavaResources) {
                return new PackageDeclarationImplNoBinding(pkgFrags);
            }
            ICompilationUnit compUnit = null;
            ICompilationUnit classFile = null;
            ICompilationUnit pkgInfoUnit = null;
            ICompilationUnit pkgInfoClassFile = null;
            IPackageFragment[] iPackageFragmentArray2 = pkgFrags;
            int n3 = pkgFrags.length;
            int n4 = 0;
            block5: while (n4 < n3) {
                int n5;
                int n6;
                ICompilationUnit[] iCompilationUnitArray;
                IPackageFragment frag = iPackageFragmentArray2[n4];
                if (frag.getKind() == 1) {
                    iCompilationUnitArray = frag.getCompilationUnits();
                    n6 = iCompilationUnitArray.length;
                    n5 = 0;
                    while (n5 < n6) {
                        ICompilationUnit unit = iCompilationUnitArray[n5];
                        if (!"package-info.java".equals(unit.getElementName())) {
                            compUnit = unit;
                            break block5;
                        }
                        pkgInfoUnit = unit;
                        ++n5;
                    }
                } else {
                    iCompilationUnitArray = frag.getOrdinaryClassFiles();
                    n6 = iCompilationUnitArray.length;
                    n5 = 0;
                    while (n5 < n6) {
                        ICompilationUnit file = iCompilationUnitArray[n5];
                        String cfName = file.getElementName();
                        if ("package-info.class".equals(cfName)) {
                            pkgInfoClassFile = file;
                        } else if (file.getElementName().indexOf("$") < 0) {
                            classFile = file;
                            break block5;
                        }
                        ++n5;
                    }
                }
                ++n4;
            }
            IType type = null;
            if (compUnit != null) {
                try {
                    IType[] types = compUnit.getAllTypes();
                    if (types.length > 0) {
                        type = types[0];
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            if (type == null && classFile != null) {
                type = classFile.getType();
            }
            if (type != null) {
                TypeDeclarationImpl typeDecl = (TypeDeclarationImpl)this.getTypeDeclaration(type);
                ITypeBinding binding = typeDecl.getDeclarationBinding();
                return new PackageDeclarationImpl(binding.getPackage(), typeDecl, this, true, pkgFrags);
            }
            if ((pkgInfoUnit != null || pkgInfoClassFile != null) && (packageBinding = (IPackageBinding)this.getBindingFromKey(key = this.getPackageBindingKey(name), compUnit)) != null) {
                return new PackageDeclarationImpl(packageBinding, null, this, true, pkgFrags);
            }
        }
        catch (JavaModelException javaModelException) {}
        return new PackageDeclarationImplNoBinding(pkgFrags);
    }

    private String getPackageBindingKey(String packageName) {
        return packageName.replace('.', '/');
    }

    protected CompilationUnit searchLocallyForBinding(IBinding binding) {
        if (this._astRoot == null) {
            throw new IllegalStateException("_astRoot is null. Check that types or environments are not being cached between builds or reconciles by user code");
        }
        ASTNode node = this._astRoot.findDeclaringNode(binding);
        if (node != null) {
            return this._astRoot;
        }
        return null;
    }

    private ICompilationUnit getICompilationUnitForTopLevelType(String topTypeQName) {
        String pathname = String.valueOf(topTypeQName.replace('.', File.separatorChar)) + DOT_JAVA;
        IPath path = Path.fromOSString((String)pathname);
        try {
            IJavaElement element = this._javaProject.findElement(path);
            if (element instanceof ICompilationUnit) {
                return (ICompilationUnit)element;
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public CompilationUnit getCompilationUnitForBinding(IBinding binding) {
        ICompilationUnit unit;
        assert (binding.getKind() == 2 || binding.getKind() == 4 || binding.getKind() == 3);
        CompilationUnit domUnit = this.searchLocallyForBinding(binding);
        if (domUnit != null) {
            return domUnit;
        }
        IMember member = (IMember)binding.getJavaElement();
        if (member != null) {
            unit = member.getCompilationUnit();
        } else {
            ITypeBinding typeBinding = BaseProcessorEnv.getDeclaringClass(binding);
            if (!typeBinding.isFromSource()) {
                return null;
            }
            if (this._typeBinding2ModelCompUnit.get(typeBinding) != null) {
                unit = this._typeBinding2ModelCompUnit.get(typeBinding);
            } else {
                String qname = typeBinding.getQualifiedName();
                unit = this.getICompilationUnitForTopLevelType(qname);
            }
        }
        if (unit == null) {
            return null;
        }
        CompilationUnit astUnit = this._modelCompUnit2astCompUnit.get(unit);
        if (astUnit != null) {
            return astUnit;
        }
        ASTParser parser = ASTParser.newParser((int)14);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        parser.setSource(unit);
        parser.setFocalPosition(0);
        parser.setIgnoreMethodBodies(true);
        CompilationUnit resultUnit = (CompilationUnit)parser.createAST(null);
        this._modelCompUnit2astCompUnit.put(unit, resultUnit);
        return resultUnit;
    }

    @Override
    public Filer getFiler() {
        throw new UnsupportedOperationException("Not supported: the EnvironmentFactory API is for type system navigation only");
    }

    @Override
    public Messager getMessager() {
        throw new UnsupportedOperationException("Not supported: the EnvironmentFactory API is for type system navigation only");
    }

    /*
     * Unable to fully structure code
     */
    protected static ITypeBinding getDeclaringClass(IBinding binding) {
        if (!BaseProcessorEnv.$assertionsDisabled && binding == null) {
            throw new AssertionError((Object)"binding cannot be null");
        }
        aTypeBinding = null;
        switch (binding.getKind()) {
            case 2: {
                aTypeBinding = (ITypeBinding)binding;
                break;
            }
            case 4: {
                aTypeBinding = ((IMethodBinding)binding).getDeclaringClass();
                break;
            }
            case 3: {
                aTypeBinding = ((IVariableBinding)binding).getDeclaringClass();
                break;
            }
            default: {
                throw new IllegalStateException("unrecognized binding type " + binding.getKind());
            }
        }
        if (aTypeBinding != null) ** GOTO lbl19
        return null;
lbl-1000:
        // 1 sources

        {
            aTypeBinding = aTypeBinding.getDeclaringClass();
lbl19:
            // 2 sources

            ** while (!aTypeBinding.isTopLevel())
        }
lbl20:
        // 1 sources

        return aTypeBinding;
    }

    public IPackageFragmentRoot[] getAllPackageFragmentRoots() throws JavaModelException {
        if (this._packageRootsCache == null) {
            this._packageRootsCache = this.getJavaProject().getAllPackageFragmentRoots();
        }
        return this._packageRootsCache;
    }

    protected IFile searchLocallyForIFile(IBinding binding) {
        if (this._astRoot == null) {
            return null;
        }
        ASTNode node = this._astRoot.findDeclaringNode(binding);
        if (node != null) {
            return this._file;
        }
        return null;
    }

    public IFile getDeclaringFileForBinding(IBinding binding) {
        assert (binding.getKind() == 2 || binding.getKind() == 4 || binding.getKind() == 3);
        IFile file = this.searchLocallyForIFile(binding);
        if (file != null) {
            return file;
        }
        IMember member = (IMember)binding.getJavaElement();
        if (member != null) {
            ICompilationUnit unit = member.getCompilationUnit();
            return (IFile)unit.getResource();
        }
        ITypeBinding type = BaseProcessorEnv.getDeclaringClass(binding);
        assert (type.isTopLevel()) : "type must be top-level type";
        ICompilationUnit unit = this._typeBinding2ModelCompUnit.get(type);
        if (unit != null) {
            return (IFile)unit.getResource();
        }
        String qname = type.getQualifiedName();
        unit = this.getICompilationUnitForTopLevelType(qname);
        if (unit == null) {
            return null;
        }
        return (IFile)unit.getResource();
    }

    static void createASTs(IJavaProject javaProject, ICompilationUnit[] parseUnits, ASTRequestor requestor) {
        String bogusKey = BindingKey.createTypeBindingKey((String)"java.lang.Object");
        String[] keys = new String[]{bogusKey};
        ASTParser p = ASTParser.newParser((int)14);
        p.setResolveBindings(true);
        p.setBindingsRecovery(true);
        p.setProject(javaProject);
        p.setKind(8);
        p.setIgnoreMethodBodies(true);
        p.createASTs(parseUnits, keys, requestor, null);
    }

    public static CompilationUnit createAST(IJavaProject javaProject, ICompilationUnit compilationUnit) {
        if (compilationUnit == null) {
            return null;
        }
        class CompilationUnitRequestor
        extends ASTRequestor {
            CompilationUnit domUnit = EMPTY_AST_UNIT;
            private final /* synthetic */ ICompilationUnit val$compilationUnit;

            CompilationUnitRequestor(ICompilationUnit iCompilationUnit) {
                this.val$compilationUnit = iCompilationUnit;
            }

            public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
                if (source == this.val$compilationUnit) {
                    this.domUnit = ast;
                }
            }
        }
        CompilationUnitRequestor requestor = new CompilationUnitRequestor(compilationUnit);
        ASTParser p = ASTParser.newParser((int)14);
        p.setResolveBindings(true);
        p.setBindingsRecovery(true);
        p.setProject(javaProject);
        p.setKind(8);
        p.setIgnoreMethodBodies(true);
        p.createASTs(new ICompilationUnit[]{compilationUnit}, NO_KEYS, (ASTRequestor)requestor, null);
        if (AptPlugin.DEBUG) {
            AptPlugin.trace("created DOM AST for " + compilationUnit.getElementName());
        }
        return requestor.domUnit;
    }

    protected AST getCurrentDietAST() {
        return this._astRoot.getAST();
    }

    private void initPrimitives() {
        if (this._primitives != null) {
            return;
        }
        AST ast = this.getCurrentDietAST();
        this._primitives = new PrimitiveTypeImpl[8];
        ITypeBinding binding = ast.resolveWellKnownType("boolean");
        if (binding == null) {
            throw new IllegalStateException("fail to locate boolean");
        }
        this._primitives[0] = new PrimitiveTypeImpl(binding);
        binding = ast.resolveWellKnownType("byte");
        if (binding == null) {
            throw new IllegalStateException("fail to locate byte");
        }
        this._primitives[1] = new PrimitiveTypeImpl(binding);
        binding = ast.resolveWellKnownType("char");
        if (binding == null) {
            throw new IllegalStateException("fail to locate byte");
        }
        this._primitives[2] = new PrimitiveTypeImpl(binding);
        binding = ast.resolveWellKnownType("double");
        if (binding == null) {
            throw new IllegalStateException("fail to locate byte");
        }
        this._primitives[3] = new PrimitiveTypeImpl(binding);
        binding = ast.resolveWellKnownType("float");
        if (binding == null) {
            throw new IllegalStateException("fail to locate byte");
        }
        this._primitives[4] = new PrimitiveTypeImpl(binding);
        binding = ast.resolveWellKnownType("int");
        if (binding == null) {
            throw new IllegalStateException("fail to locate byte");
        }
        this._primitives[5] = new PrimitiveTypeImpl(binding);
        binding = ast.resolveWellKnownType("long");
        if (binding == null) {
            throw new IllegalStateException("fail to locate byte");
        }
        this._primitives[6] = new PrimitiveTypeImpl(binding);
        binding = ast.resolveWellKnownType("short");
        if (binding == null) {
            throw new IllegalStateException("fail to locate byte");
        }
        this._primitives[7] = new PrimitiveTypeImpl(binding);
        binding = ast.resolveWellKnownType("void");
        if (binding == null) {
            throw new IllegalStateException("fail to locate byte");
        }
        this._voidType = new VoidTypeImpl(binding);
    }

    public PrimitiveTypeImpl getBooleanType() {
        this.initPrimitives();
        return this._primitives[0];
    }

    public PrimitiveTypeImpl getByteType() {
        this.initPrimitives();
        return this._primitives[1];
    }

    public PrimitiveTypeImpl getCharType() {
        this.initPrimitives();
        return this._primitives[2];
    }

    public PrimitiveTypeImpl getDoubleType() {
        this.initPrimitives();
        return this._primitives[3];
    }

    public PrimitiveTypeImpl getFloatType() {
        this.initPrimitives();
        return this._primitives[4];
    }

    public PrimitiveTypeImpl getIntType() {
        this.initPrimitives();
        return this._primitives[5];
    }

    public PrimitiveTypeImpl getLongType() {
        this.initPrimitives();
        return this._primitives[6];
    }

    public PrimitiveTypeImpl getShortType() {
        this.initPrimitives();
        return this._primitives[7];
    }

    public VoidTypeImpl getVoidType() {
        this.initPrimitives();
        return this._voidType;
    }

    public CompilationUnit getAstCompilationUnit() {
        return this._astRoot;
    }

    public IFile getFile() {
        return this._file;
    }

    public Phase getPhase() {
        return this._phase;
    }

    public IProject getProject() {
        return this._javaProject.getProject();
    }

    public IJavaProject getJavaProject() {
        return this._javaProject;
    }

    public AptProject getAptProject() {
        return this._aptProject;
    }

    public boolean isTestCode() {
        return this._isTestCode;
    }

    static class BaseRequestor
    extends ASTRequestor {
        ICompilationUnit[] parseUnits;
        CompilationUnit[] asts;

        BaseRequestor(ICompilationUnit[] parseUnits) {
            this.asts = new CompilationUnit[parseUnits.length];
            Arrays.fill(this.asts, EMPTY_AST_UNIT);
            this.parseUnits = parseUnits;
        }

        public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
            int i = 0;
            int len = this.asts.length;
            while (i < len) {
                if (source == this.parseUnits[i]) {
                    this.asts[i] = ast;
                    break;
                }
                ++i;
            }
        }
    }
}

