/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.network;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;

public class PortUtil {
    private static PortUtil singleton;
    private ServerSocket ss;
    int basePort = this.nextPort = OseeProperties.getOseePortScannerStartPort();
    int nextPort = 18000;

    public static PortUtil getInstance() {
        if (singleton == null) {
            singleton = new PortUtil();
        }
        return singleton;
    }

    private PortUtil() {
        int j = this.nextPort;
        while (j < 64000) {
            if (this.checkIfPortIsTaken(j)) {
                this.basePort = this.nextPort = j;
                try {
                    this.ss = new ServerSocket(this.basePort);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            j += 250;
        }
    }

    public void computeNewBasePort() {
        this.basePort = this.nextPort = this.basePort + 1000;
        int j = this.nextPort;
        while (j < 64000) {
            if (this.checkIfPortIsTaken(j)) {
                this.basePort = this.nextPort = j;
                try {
                    this.ss = new ServerSocket(this.basePort);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            j += 250;
        }
    }

    public int getValidPort() throws IOException {
        int port = this.getConsecutiveValidPorts(1);
        return port;
    }

    public int getConsecutiveValidPorts(int numberOfPorts) throws IOException {
        try {
            int returnVal = this.getConsecutiveLocalPorts(numberOfPorts);
            this.nextPort = returnVal + numberOfPorts;
            return returnVal;
        }
        catch (Exception e) {
            e.printStackTrace();
            IOException ioE = new IOException("Unable to get a valid port.");
            ioE.initCause(e);
            throw ioE;
        }
    }

    private int getConsecutiveLocalPorts(int numberOfPorts) throws Exception {
        if (this.nextPort >= this.basePort + 250 - numberOfPorts) {
            this.nextPort = this.basePort;
        }
        int i = this.nextPort;
        while (i < this.basePort + 250) {
            boolean passed = true;
            int j = i;
            while (j < numberOfPorts + i) {
                if (!this.checkIfPortIsTaken(j)) {
                    passed = false;
                    break;
                }
                ++j;
            }
            if (passed) {
                return i;
            }
            ++i;
        }
        throw new Exception("Unable to find valid port.");
    }

    private boolean checkIfPortIsTaken(int port) {
        return this.checkTcpIp(port) && this.checkUdpPort(port);
    }

    private boolean checkTcpIp(int port) {
        try {
            ServerSocket socket = new ServerSocket(port);
            socket.close();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean checkUdpPort(int port) {
        try {
            DatagramSocket ds = new DatagramSocket(port, InetAddress.getLocalHost());
            ds.close();
            ds.disconnect();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

