/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.ReservedCharacters;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AXml {
    public static String getRootTag(String xmlStr) {
        Matcher m = Pattern.compile("^[\r\n \t]*<.*?>[\r\n \t]*<(.*?)>", 40).matcher(xmlStr);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    public static String addTagData(String elementName, String data) {
        return AXml.addTagData(elementName, data, false);
    }

    public static String addTagData(String elementName, Collection<Integer> data, String separator) {
        return AXml.addTagData(elementName, Collections.toString(separator, data), false);
    }

    public static String addTagData(String elementName, String data, boolean newLine) {
        String str = "<" + elementName + ">" + data + "</" + elementName + ">";
        if (newLine) {
            return String.valueOf(str) + "\n";
        }
        return str;
    }

    public static String[] getNameValue(String xmlRoot, String xmlStr) {
        String[] strs = new String[]{"", ""};
        Matcher m = Pattern.compile("<" + xmlRoot + " name=\"(.*?)\" value=\"(.*?)\" />", 40).matcher(xmlStr);
        if (m.find()) {
            strs[0] = m.group(1);
            strs[1] = m.group(2);
        }
        return strs;
    }

    public static String getNameValueXml(String xmlRoot, String name, String value) {
        return String.format("<%s name=\"%s\" value=\"%s\"/>", xmlRoot, name, value);
    }

    public static String[] getTagDataArray(String xmlStr, String xmlRoot) {
        Vector<String> v = new Vector<String>();
        Matcher m = Pattern.compile("<" + xmlRoot + ">(.*?)</" + xmlRoot + ">", 40).matcher(xmlStr);
        while (m.find()) {
            v.add(AXml.xmlToText(m.group(1)));
        }
        return v.toArray(new String[v.size()]);
    }

    public static List<Integer> getTagIntegerDataArray(String xmlStr, String xmlRoot, String separator) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        Matcher m = Pattern.compile("<" + xmlRoot + ">(.*?)</" + xmlRoot + ">", 40).matcher(xmlStr);
        while (m.find()) {
            String[] stringArray = m.group(1).split(separator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                results.add(new Integer(AXml.xmlToText(str)));
                ++n2;
            }
        }
        return results;
    }

    public static String getTagData(String xmlStr, String xmlRoot) {
        String[] tags = AXml.getTagDataArray(xmlStr, xmlRoot);
        if (tags.length > 0) {
            return tags[0];
        }
        return "";
    }

    public static int getTagIntData(String xmlStr, String xmlRoot) {
        String[] tags = AXml.getTagDataArray(xmlStr, xmlRoot);
        if (tags.length > 0) {
            String intStr = tags[0];
            return new Integer(intStr);
        }
        return 0;
    }

    public static Boolean getTagBooleanData(String xmlStr, String xmlRoot) {
        String[] tags = AXml.getTagDataArray(xmlStr, xmlRoot);
        if (tags.length > 0) {
            String intStr = tags[0];
            return intStr.equals("true");
        }
        return false;
    }

    public static Integer getTagIntegerData(String xmlStr, String xmlRoot) {
        String[] tags = AXml.getTagDataArray(xmlStr, xmlRoot);
        if (tags.length > 0) {
            String intStr = tags[0];
            return new Integer(intStr);
        }
        return null;
    }

    public static String textToXml(String text) {
        if (!Strings.isValid(text)) {
            return "";
        }
        return ReservedCharacters.encodeXmlEntities(text);
    }

    public static String xmlToText(String xml) {
        if (!Strings.isValid(xml)) {
            return "";
        }
        String str = xml;
        str = str.replaceAll("&gt;", ">");
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&apos;", "'");
        str = str.replaceAll("&quot;", "\"");
        str = str.replaceAll("&amp;", "&");
        return str;
    }

    public static String removeXmlTags(String str) {
        return str.replaceAll("<[^>]+>", "");
    }
}

