/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osee.framework.jdk.core.type.IVariantData;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class VariantData
implements IVariantData {
    private static final String EXCEPTION_MESSAGE = "No setting found for key: [%s]";
    private static final String CONVERSION_EXCEPTION_MESSAGE = "Unable to convert [%s] from [%s] to [%s]";
    private final Properties storageData;
    private final Properties storageArrays;
    private final Map<String, byte[]> byteArrayData = new HashMap<String, byte[]>();

    public VariantData() {
        this.storageData = new Properties();
        this.storageArrays = new Properties();
    }

    @Override
    public String get(String key) {
        return (String)this.storageData.get(key);
    }

    @Override
    public boolean isEmpty(String key) {
        if (this.get(key) == null) {
            return true;
        }
        return this.get(key).equals("");
    }

    @Override
    public String[] getArray(String key) {
        return (String[])this.storageArrays.get(key);
    }

    @Override
    public boolean getBoolean(String key) {
        return Boolean.valueOf((String)this.storageData.get(key));
    }

    @Override
    public double getDouble(String key) throws NumberFormatException {
        String setting = (String)this.storageData.get(key);
        if (setting == null) {
            throw new NumberFormatException(String.format(EXCEPTION_MESSAGE, key));
        }
        return new Double(setting);
    }

    @Override
    public float getFloat(String key) throws NumberFormatException {
        String setting = (String)this.storageData.get(key);
        if (setting == null) {
            throw new NumberFormatException(String.format(EXCEPTION_MESSAGE, key));
        }
        return new Float(setting).floatValue();
    }

    @Override
    public int getInt(String key) throws NumberFormatException {
        String setting = (String)this.storageData.get(key);
        if (setting == null) {
            throw new NumberFormatException(String.format(EXCEPTION_MESSAGE, key));
        }
        return new Integer(setting);
    }

    @Override
    public long getLong(String key) throws NumberFormatException {
        String setting = (String)this.storageData.get(key);
        if (setting == null) {
            throw new NumberFormatException(String.format(EXCEPTION_MESSAGE, key));
        }
        return new Long(setting);
    }

    @Override
    public Date getDate(String key) throws IllegalArgumentException {
        String setting = (String)this.storageData.get(key);
        if (setting == null) {
            throw new IllegalArgumentException(String.format(EXCEPTION_MESSAGE, key));
        }
        return new Date(new Long(setting));
    }

    @Override
    public Date getDateOrNull(String key) throws IllegalArgumentException {
        if (this.storageData.get(key) == null) {
            return null;
        }
        return this.getDate(key);
    }

    @Override
    public String getStreamAsString(String key) throws Exception {
        String toReturn;
        InputStream inputStream = this.getStream(key);
        try {
            toReturn = Lib.inputStreamToString(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(String.format(CONVERSION_EXCEPTION_MESSAGE, key, "byte[]", "String"));
        }
        return toReturn;
    }

    @Override
    public InputStream getStream(String key) throws IllegalArgumentException {
        byte[] bytes = this.byteArrayData.get(key);
        if (bytes == null) {
            throw new IllegalArgumentException(String.format(EXCEPTION_MESSAGE, key));
        }
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public void put(String key, String[] value) {
        if (value == null) {
            value = new String[]{};
        }
        this.storageArrays.put(key, value);
    }

    @Override
    public void put(String key, double value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(String key, float value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(String key, int value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(String key, long value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(String key, Date date) {
        if (date != null) {
            this.put(key, date.getTime());
        }
    }

    @Override
    public void put(String key, String value) {
        if (value == null) {
            value = "";
        }
        this.storageData.put(key, value);
    }

    @Override
    public void put(String key, byte[] bytes) {
        if (bytes == null) {
            bytes = new byte[]{};
        }
        this.byteArrayData.put(key, bytes);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.storageData.toString().replaceAll(",", ",\n"));
        builder.append(this.storageArrays.toString().replaceAll(",", ",\n"));
        for (String key : this.byteArrayData.keySet()) {
            builder.append(key);
            builder.append("=");
            try {
                builder.append(this.getStreamAsString(key));
            }
            catch (Exception exception) {
                builder.append("!!Error!!");
            }
            builder.append(",\n");
        }
        return builder.toString();
    }
}

