/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text.tool;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.text.FindResults;
import org.eclipse.osee.framework.jdk.core.text.tool.Find;
import org.eclipse.osee.framework.jdk.core.text.tool.FindNonLocalFunctionCalls;
import org.eclipse.osee.framework.jdk.core.text.tool.FindResultsIterator;
import org.eclipse.osee.framework.jdk.core.text.tool.StripBlockComments;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class FunctionCallStats {
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Usage: FunctionCallStats <search directory> <fileName pattern>");
            return;
        }
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.add("\\W(\\w+)\\s*\\([^;{]*?\\)\\s*;");
        BufferedWriter out = new BufferedWriter(new FileWriter("results.csv"));
        List<File> files = Lib.recursivelyListFiles(new File(args[0]), Pattern.compile(args[1]));
        System.out.println("Searching " + files.size() + " files...");
        FindNonLocalFunctionCalls nonLocalFindApp = new FindNonLocalFunctionCalls(files.toArray(new File[files.size()]));
        nonLocalFindApp.searchFiles();
        Set<String> nonLocalFunctions = nonLocalFindApp.getResultSet();
        Find app = new Find(patterns, files, new StripBlockComments());
        app.setRegionPadding(0, 0);
        app.find(999999, true);
        FindResults results = app.getResults();
        String lastFileName = null;
        class Counter {
            public int count = 0;

            Counter() {
            }
        }
        HashMap<String, Counter> functions = new HashMap<String, Counter>(1000);
        FindResultsIterator i = results.iterator();
        while (i.hasNext()) {
            Counter counter;
            String currentFileName = i.currentFile.getName();
            if (i.currentRegion == null) continue;
            if (!currentFileName.equals(lastFileName)) {
                for (Map.Entry entry : functions.entrySet()) {
                    String functionName = (String)entry.getKey();
                    if (!nonLocalFunctions.contains(functionName)) continue;
                    out.write(lastFileName);
                    out.write(44);
                    out.write(functionName);
                    out.write(44);
                    out.write(String.valueOf(((Counter)entry.getValue()).count));
                    out.write(10);
                }
                lastFileName = currentFileName;
                functions.clear();
            }
            if ((counter = (Counter)functions.get(i.currentRegion)) == null) {
                counter = new Counter();
            }
            ++counter.count;
            functions.put(i.currentRegion, counter);
        }
        out.close();
    }
}

