/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.change;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeReportRollup;

public class ChangeItemData {
    private final Collection<ChangeItem> changes;
    private boolean loaded = false;
    private final Map<ArtifactId, ChangeReportRollup> rollups = new HashMap<ArtifactId, ChangeReportRollup>();

    public ChangeItemData(Collection<ChangeItem> changes) {
        this.changes = changes;
    }

    public boolean isEmpty() {
        return this.getChanges() == null || this.getChanges().isEmpty();
    }

    public Collection<ChangeItem> getChanges() {
        return this.changes;
    }

    public void ensureLoaded() {
        if (!this.loaded) {
            for (ChangeItem item : this.changes) {
                ArtifactId artA = item.getArtId();
                this.processArtifact(artA, item);
                ArtifactId artB = item.getArtIdB();
                this.processArtifact(artB, item);
            }
            this.loaded = true;
        }
    }

    public void processArtifact(ArtifactId art, ChangeItem item) {
        if (art.isValid()) {
            ChangeReportRollup rollup = this.rollups.get(art);
            if (rollup == null) {
                rollup = new ChangeReportRollup(art);
                this.rollups.put(art, rollup);
            }
            rollup.getChangeItems().add(item);
        }
    }

    public Map<ArtifactId, ChangeReportRollup> getRollups() {
        this.ensureLoaded();
        return this.rollups;
    }
}

