/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.util.health;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.CountingMap;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.MutableInteger;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class HealthCheckResults {
    private final CountingMap<String> testNameToTimeSpentMap = new CountingMap();
    private final HashCollection<String, String> testNameToResultsMap = new HashCollection(50);
    private final HashCollection<String, String> testNameToIdMap = new HashCollection(50);

    public void logTestTimeSpent(Date date, String testName) {
        Date now = new Date();
        int spent = new Long(now.getTime() - date.getTime()).intValue();
        this.testNameToTimeSpentMap.put((Object)testName, spent);
    }

    public void log(ArtifactId artifact, String testName, String message) {
        if (artifact != null) {
            this.testNameToIdMap.put((Object)testName, (Object)artifact.getIdString());
        }
        this.log(testName, message);
    }

    public void log(String testName, String message) {
        this.testNameToResultsMap.put((Object)testName, (Object)message);
    }

    public void addResultsMapToResultData(XResultData xResultData) {
        Object[] keys = this.testNameToResultsMap.keySet().toArray(new String[this.testNameToResultsMap.keySet().size()]);
        Arrays.sort(keys);
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object testName = objectArray[n2];
            xResultData.log((String)testName);
            for (String result : (List)this.testNameToResultsMap.getValues(testName)) {
                xResultData.log("   - " + result);
            }
            HashSet idStrs = new HashSet();
            Collection values = this.testNameToIdMap.getValues(testName);
            if (values != null) {
                idStrs.addAll(values);
            }
            xResultData.log(String.valueOf(testName) + "IDs: " + Collections.toString((String)",", idStrs) + "\n");
            ++n2;
        }
    }

    public void addTestTimeMapToResultData(XResultData xResultData) {
        xResultData.log("\n\nTime Spent in Tests");
        long totalTime = 0L;
        for (Map.Entry entry : this.testNameToTimeSpentMap.getCounts()) {
            xResultData.log("   " + (String)entry.getKey() + " - " + ((MutableInteger)entry.getValue()).getValue() / 1000 + " sec " + " - " + entry.getValue() + " ms");
            totalTime += (long)((MutableInteger)entry.getValue()).getValue();
        }
        xResultData.log("TOTAL - " + totalTime / 1000L + " sec " + totalTime + " ms");
        xResultData.log("\n");
    }

    public HashCollection<String, String> getTestNameToResultsMap() {
        return this.testNameToResultsMap;
    }
}

