/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.executor.internal;

import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;

public class ExecutorCache {
    private final ConcurrentHashMap<String, ListeningExecutorService> executors = new ConcurrentHashMap();

    public void put(String id, ListeningExecutorService service) {
        if (this.executors.putIfAbsent(id, service) != null) {
            throw new OseeStateException("Error non-unique executor detected [%s]", new Object[]{id});
        }
    }

    public ListeningExecutorService getById(String id) {
        if (id == null || id.length() <= 0) {
            throw new OseeArgumentException("Error - executorId cannot be null", new Object[0]);
        }
        ListeningExecutorService executor = this.executors.get(id);
        if (executor != null && (executor.isShutdown() || executor.isTerminated())) {
            this.executors.remove(id);
            executor = null;
        }
        return executor;
    }

    public Map<String, ListeningExecutorService> getExecutors() {
        return this.executors;
    }

    public void remove(String id) {
        this.executors.remove(id);
    }
}

