/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.enums;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public abstract class OseeEnum
extends NamedIdBase {
    protected static final HashCollection<Long, OseeEnum> idToEnums = new HashCollection(15);

    public OseeEnum(Long typeId, String name) {
        super(Long.valueOf(-1L), name);
        Long id = this.values().size();
        this.validateId(typeId, id);
        this.setId(Long.valueOf(this.values().size()));
        idToEnums.put((Object)typeId, (Object)this);
    }

    public OseeEnum(Long typeId, Long ordinal, String name) {
        super(ordinal, name);
        this.validateId(typeId, ordinal);
        idToEnums.put((Object)typeId, (Object)this);
    }

    private void validateId(Long typeId, Long id) {
        List values = (List)idToEnums.getValues((Object)typeId);
        if (values != null) {
            for (OseeEnum oEnum : values) {
                if (!oEnum.getId().equals(id)) continue;
                throw new OseeArgumentException("Duplicate Ids %s for Same Enum Type %s", new Object[]{id, typeId});
            }
        }
    }

    public abstract Long getTypeId();

    @JsonIgnore
    public abstract OseeEnum getDefault();

    public OseeEnum get(String name) {
        for (OseeEnum oEnum : (List)idToEnums.getValues((Object)this.getTypeId())) {
            if (!oEnum.name().equals(name)) continue;
            return oEnum;
        }
        return this.getDefault();
    }

    public OseeEnum get(Long id) {
        for (OseeEnum oEnum : (List)idToEnums.getValues((Object)this.getTypeId())) {
            if (!oEnum.getId().equals(id)) continue;
            return oEnum;
        }
        return this.getDefault();
    }

    public String name() {
        return this.getName();
    }

    public Collection<OseeEnum> values() {
        Collection values = idToEnums.getValues((Object)this.getTypeId());
        if (values == null) {
            return Collections.emptyList();
        }
        return values;
    }
}

