/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.enums;

public enum ConflictStatus {
    NOT_CONFLICTED(0),
    UNTOUCHED(1),
    EDITED(2),
    RESOLVED(3),
    OUT_OF_DATE_RESOLVED(4),
    COMMITTED(6),
    INFORMATIONAL(7),
    OUT_OF_DATE(8),
    PREVIOUS_MERGE_APPLIED_SUCCESS(9),
    PREVIOUS_MERGE_APPLIED_CAUTION(10);

    private final int value;

    private ConflictStatus(int value) {
        this.value = value;
    }

    public final int getValue() {
        return this.value;
    }

    public boolean isConflict() {
        return this != NOT_CONFLICTED;
    }

    public boolean isCommitted() {
        return this == COMMITTED;
    }

    public boolean isOutOfDate() {
        return this == OUT_OF_DATE;
    }

    public boolean isInformational() {
        return this == INFORMATIONAL;
    }

    public boolean isUntouched() {
        return this == UNTOUCHED;
    }

    public boolean isOutOfDateCommitted() {
        return this == OUT_OF_DATE_RESOLVED;
    }

    public boolean isResolved() {
        return this == RESOLVED;
    }

    public boolean isEdited() {
        return this == EDITED;
    }

    public boolean isPreviousMergeAppliedWithCaution() {
        return this == PREVIOUS_MERGE_APPLIED_CAUTION;
    }

    public boolean isPreviousMergeSuccessfullyApplied() {
        return this == PREVIOUS_MERGE_APPLIED_SUCCESS;
    }

    public boolean isIgnoreable() {
        return this.isInformational();
    }

    public boolean isEditable() {
        return !this.isResolved() && !this.isCommitted() && !this.isInformational();
    }

    public boolean isResolvable() {
        return !this.isInformational() && !this.isCommitted();
    }

    public boolean isOverwriteAllowed() {
        return !this.isResolved() && !this.isCommitted();
    }

    public boolean isConsideredResolved() {
        return this.isResolved() || this.isCommitted() || this.isInformational();
    }

    public static ConflictStatus valueOf(String string) {
        return Enum.valueOf(ConflictStatus.class, string);
    }
}

