/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.io.InputStream;
import java.sql.Timestamp;
import org.eclipse.osee.framework.core.data.BaseExchangeData;

public class OseeServerInfo
extends BaseExchangeData {
    private static final long serialVersionUID = 2696663265012016128L;
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final String SERVER_URI = "uri";
    protected static final String VERSION = "version";
    private static final String DATE_CREATED = "creationDate";
    private static final String SERVER_ID = "serverId";
    protected static final String IS_ACCEPTING_REQUESTS = "isAcceptingRequests";
    private int port;

    public OseeServerInfo() {
    }

    public OseeServerInfo(String serverId, String uri, int port, String[] version, Timestamp dateStarted, boolean isAcceptingRequests) {
        this();
        this.backingData.put(SERVER_ID, serverId);
        this.backingData.put(SERVER_URI, uri);
        this.backingData.put(VERSION, version);
        this.backingData.put(DATE_CREATED, dateStarted.getTime());
        this.backingData.put(IS_ACCEPTING_REQUESTS, isAcceptingRequests);
        this.port = port;
    }

    public String getServerId() {
        return this.getString(SERVER_ID);
    }

    public String getUri() {
        return this.getString(SERVER_URI);
    }

    public String[] getVersion() {
        String[] toReturn = this.backingData.getArray(VERSION);
        return toReturn != null ? toReturn : EMPTY_ARRAY;
    }

    public boolean isAcceptingRequests() {
        return this.backingData.getBoolean(IS_ACCEPTING_REQUESTS);
    }

    public Timestamp getDateStarted() {
        return new Timestamp(this.backingData.getLong(DATE_CREATED));
    }

    public static OseeServerInfo fromXml(InputStream inputStream) {
        OseeServerInfo serverInfo = new OseeServerInfo();
        serverInfo.loadfromXml(inputStream);
        return serverInfo;
    }

    public int getPort() {
        return this.port;
    }
}

