/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.access.context.AccessContext;
import org.eclipse.osee.framework.core.data.AccessContextToken;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.logging.OseeLog;

public class AccessControlUtil {
    private static boolean debugOn = false;
    private static Boolean logDebugOn = null;

    private AccessControlUtil() {
    }

    public static Collection<AccessContext> getContexts(Collection<AccessContextToken> contextIds, XResultData rd) {
        ArrayList<AccessContext> contexts = new ArrayList<AccessContext>();
        for (AccessContextToken token : contextIds) {
            AccessContext accessContext = AccessContext.getAccessContext(token);
            if (accessContext == null) {
                OseeLog.logf(AccessControlUtil.class, (Level)Level.SEVERE, (String)"Context Id: No Access Context can be found for Context Id [%s]", (Object[])new Object[]{token.toStringWithId()});
                rd.errorf("Context Id: No Access Context can be found for Context Id [%s]", new Object[]{token.toStringWithId()});
                continue;
            }
            contexts.add(accessContext);
        }
        return contexts;
    }

    public static void errorf(String message, Object ... data) {
        if (logDebugOn == null) {
            logDebugOn = "true".equals(System.getProperty("access.debug"));
        }
        if (debugOn || logDebugOn.booleanValue()) {
            XConsoleLogger.err((String)message, (Object[])data);
        }
        if (logDebugOn.booleanValue()) {
            OseeLog.log(AccessControlUtil.class, (Level)Level.INFO, (String)String.format(message, data));
        }
    }

    public static void setDebugOn(boolean debugOn) {
        logDebugOn = debugOn;
    }

    public static boolean isDebugOn() {
        return logDebugOn;
    }
}

