/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.branch.gantt.views;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.nebula.widgets.ganttchart.GanttChart;
import org.eclipse.nebula.widgets.ganttchart.GanttComposite;
import org.eclipse.nebula.widgets.ganttchart.GanttEvent;
import org.eclipse.nebula.widgets.ganttchart.ISettings;
import org.eclipse.osee.branch.gantt.Activator;
import org.eclipse.osee.branch.gantt.views.BranchGanttSettings;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.widgets.XBranchSelectWidget;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class BranchVisualizationView
extends ViewPart {
    public static final String ID = "org.eclipse.osee.branch.gantt.views.BranchVisualizationView";
    private GanttChart ganttChart;
    private Action zoomOutAction;
    private Action zoomInAction;
    private Action refreshAction;
    private Composite parent;
    private BranchGanttSettings settings;
    private XBranchSelectWidget xBranchSelectWidget;
    private static String BRANCH_KEY = "branch.visualization.default";
    private Composite bodyComposite;
    private Composite bottomGroup1;
    private Composite bottomGroup2;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.setTitleImage(ImageManager.getImage((KeyedImage)FrameworkImage.BRANCH));
        this.bodyComposite = new Composite(parent, 0);
        this.bodyComposite.setLayout((Layout)new GridLayout(1, false));
        this.bodyComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.bodyComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BranchVisualizationView.this.storeSelectedBranch();
            }
        });
        this.addBranchSelection();
        this.drawChart();
        this.makeActions();
        this.contributeToActionBars();
    }

    private void storeSelectedBranch() {
        BranchToken selectedBranch;
        if (this.xBranchSelectWidget != null && !this.xBranchSelectWidget.getControl().isDisposed() && (selectedBranch = this.xBranchSelectWidget.getData()) != null) {
            try {
                UserManager.getUser().setSetting(BRANCH_KEY, selectedBranch.getId());
                UserManager.getUser().persist("Store Branch Visualization Default Branch");
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
    }

    private void addBranchSelection() {
        this.xBranchSelectWidget = new XBranchSelectWidget("");
        this.xBranchSelectWidget.setDisplayLabel(false);
        this.xBranchSelectWidget.createWidgets(this.bodyComposite, 1);
        this.xBranchSelectWidget.addListener(new Listener(){

            public void handleEvent(Event event) {
                BranchVisualizationView.this.drawChart();
            }
        });
        this.loadLastSelectedBranch();
    }

    private void loadLastSelectedBranch() {
        try {
            String branchUuid = UserManager.getUser().getSetting(BRANCH_KEY);
            if (Strings.isValid((String)branchUuid)) {
                try {
                    BranchToken branch = BranchManager.getBranchToken((Long)Long.valueOf(branchUuid));
                    this.xBranchSelectWidget.setSelection(branch);
                }
                catch (Exception exception) {}
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    private BranchId getSelectedBranch() {
        return this.xBranchSelectWidget.getData();
    }

    public void drawChart() {
        if (this.ganttChart != null && !this.ganttChart.isDisposed()) {
            this.ganttChart.dispose();
        }
        if (this.bottomGroup1 != null && !this.bottomGroup1.isDisposed()) {
            this.bottomGroup1.dispose();
        }
        if (this.bottomGroup2 != null && !this.bottomGroup2.isDisposed()) {
            this.bottomGroup2.dispose();
        }
        if (this.settings == null) {
            this.settings = new BranchGanttSettings();
        }
        this.ganttChart = new GanttChart(this.bodyComposite, 0, (ISettings)this.settings);
        this.ganttChart.setLayout((Layout)new GridLayout(1, false));
        this.ganttChart.setLayoutData((Object)new GridData(4, 4, true, true));
        try {
            this.createEvents(null, BranchManager.getBranchToken((BranchId)this.getSelectedBranch()), true);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        this.createBottom(this.bodyComposite);
        this.bodyComposite.layout();
        this.parent.layout();
    }

    public GanttEvent createEvents(GanttEvent parentEvent, BranchToken branch, boolean recurse) {
        GanttEvent gantEvent = this.createGantEvent(parentEvent, branch);
        if (recurse) {
            for (BranchToken childBranch : BranchManager.getChildBranches((BranchId)branch, (boolean)false)) {
                if (!BranchManager.getType((BranchId)childBranch).isBaselineBranch()) continue;
                this.createEvents(gantEvent, childBranch, recurse);
            }
        }
        return gantEvent;
    }

    private GanttEvent createGantEvent(GanttEvent parentEvent, BranchToken branch) {
        Calendar creationDateCal = Calendar.getInstance();
        Date createDate = BranchManager.getBaseTransaction((BranchId)branch).getTimeStamp();
        creationDateCal.setTime(createDate);
        Calendar endDate = Calendar.getInstance();
        List transactionsForBranch = TransactionManager.getTransactionsForBranch((BranchId)branch);
        Date lastTransactionDate = this.getLastTransactionDate(transactionsForBranch);
        endDate.setTime(lastTransactionDate);
        GanttEvent gantEvent = new GanttEvent(this.ganttChart, branch.getName(), creationDateCal, endDate, 35);
        if (parentEvent != null) {
            this.ganttChart.addConnection(parentEvent, gantEvent);
        }
        return gantEvent;
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.zoomInAction);
        manager.add((IAction)this.zoomOutAction);
        manager.add((IAction)this.refreshAction);
    }

    private void makeActions() {
        this.zoomInAction = new Action(){

            public void run() {
                BranchVisualizationView.this.ganttChart.getGanttComposite().zoomIn();
            }
        };
        this.zoomInAction.setText("Zoom In");
        this.zoomInAction.setToolTipText("Zoom In");
        this.zoomInAction.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.ZOOM_IN));
        this.zoomOutAction = new Action(){

            public void run() {
                BranchVisualizationView.this.ganttChart.getGanttComposite().zoomOut();
            }
        };
        this.zoomOutAction.setText("Zoom Out");
        this.zoomOutAction.setToolTipText("Zoom Out");
        this.zoomOutAction.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.ZOOM_OUT));
        this.refreshAction = new Action(){

            public void run() {
                BranchVisualizationView.this.drawChart();
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh");
        this.refreshAction.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.REFRESH));
    }

    private Date getLastTransactionDate(List<TransactionRecord> transactionsForBranch) {
        Date lastDate = null;
        for (TransactionRecord record : transactionsForBranch) {
            if (lastDate != null && !lastDate.before(record.getTimeStamp())) continue;
            lastDate = record.getTimeStamp();
        }
        return lastDate;
    }

    public void original(Composite parent) {
        this.ganttChart = new GanttChart(parent, 0);
        Calendar sdEventOne = Calendar.getInstance();
        Calendar edEventOne = Calendar.getInstance();
        edEventOne.add(5, 10);
        Calendar sdEventTwo = Calendar.getInstance();
        Calendar edEventTwo = Calendar.getInstance();
        sdEventTwo.add(5, 11);
        edEventTwo.add(5, 15);
        Calendar cpDate = Calendar.getInstance();
        cpDate.add(5, 16);
        GanttEvent eventOne = new GanttEvent(this.ganttChart, "Scope Event 1", sdEventOne, edEventOne, 35);
        GanttEvent eventTwo = new GanttEvent(this.ganttChart, "Scope Event 2", sdEventTwo, edEventTwo, 10);
        GanttEvent eventThree = new GanttEvent(this.ganttChart, "Checkpoint", cpDate, cpDate, 75);
        eventThree.setCheckpoint(true);
        this.ganttChart.addConnection(eventOne, eventTwo);
        this.ganttChart.addConnection(eventTwo, eventThree);
        parent.layout();
    }

    public void setFocus() {
        this.ganttChart.setFocus();
    }

    private void createBottom(Composite parent) {
        this.bottomGroup1 = new Composite(parent, 0);
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 200;
        this.bottomGroup1.setLayoutData((Object)layoutData);
        this.bottomGroup1.setLayout((Layout)new GridLayout(8, false));
        Button bJumpEarliest = new Button(this.bottomGroup1, 8);
        bJumpEarliest.setText("Jump to earliest event");
        Button bJumpLatest = new Button(this.bottomGroup1, 8);
        bJumpLatest.setText("Jump to latest event");
        Button bSelectFirstEvent = new Button(this.bottomGroup1, 8);
        bSelectFirstEvent.setText("Show first event");
        Button bSelectMidEvent = new Button(this.bottomGroup1, 8);
        bSelectMidEvent.setText("Show middle event");
        Button bSelectLastEvent = new Button(this.bottomGroup1, 8);
        bSelectLastEvent.setText("Show last event");
        Button bJumpToCurrentTimeLeft = new Button(this.bottomGroup1, 8);
        bJumpToCurrentTimeLeft.setText("Today [Left]");
        Button bJumpToCurrentTimeCenter = new Button(this.bottomGroup1, 8);
        bJumpToCurrentTimeCenter.setText("Today [Center]");
        Button bJumpToCurrentTimeRight = new Button(this.bottomGroup1, 8);
        bJumpToCurrentTimeRight.setText("Today [Right]");
        this.bottomGroup2 = new Composite(parent, 0);
        layoutData = new GridData(768);
        layoutData.widthHint = 200;
        this.bottomGroup2.setLayoutData((Object)layoutData);
        this.bottomGroup2.setLayout((Layout)new GridLayout(8, false));
        Button zIn = new Button(this.bottomGroup2, 8);
        Button zOut = new Button(this.bottomGroup2, 8);
        zIn.setText("Zoom In");
        zOut.setText("Zoom Out");
        Button bShowPlanned = new Button(this.bottomGroup2, 8);
        bShowPlanned.setText("Toggle Planned Dates");
        Button bShowDays = new Button(this.bottomGroup2, 8);
        bShowDays.setText("Toggle Dates On Events");
        final GanttComposite _ganttComposite = this.ganttChart.getGanttComposite();
        bJumpEarliest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                _ganttComposite.jumpToEarliestEvent();
                BranchVisualizationView.this.moveFocus();
            }
        });
        bJumpLatest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                _ganttComposite.jumpToLatestEvent();
                BranchVisualizationView.this.moveFocus();
            }
        });
        bSelectFirstEvent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (_ganttComposite.getEvents().size() == 0) {
                    return;
                }
                _ganttComposite.setTopItem((GanttEvent)_ganttComposite.getEvents().get(0), 0x1000000);
                BranchVisualizationView.this.moveFocus();
            }
        });
        bSelectLastEvent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (_ganttComposite.getEvents().size() == 0) {
                    return;
                }
                _ganttComposite.setTopItem((GanttEvent)_ganttComposite.getEvents().get(_ganttComposite.getEvents().size() - 1), 0x1000000);
                BranchVisualizationView.this.moveFocus();
            }
        });
        bSelectMidEvent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (_ganttComposite.getEvents().size() < 2) {
                    return;
                }
                GanttEvent ge = (GanttEvent)_ganttComposite.getEvents().get(_ganttComposite.getEvents().size() / 2);
                _ganttComposite.setTopItem(ge, 0x1000000);
                BranchVisualizationView.this.moveFocus();
            }
        });
        bJumpToCurrentTimeLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Calendar currentDate = Calendar.getInstance();
                _ganttComposite.setDate(currentDate, 16384);
                BranchVisualizationView.this.moveFocus();
            }
        });
        bJumpToCurrentTimeCenter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Calendar currentDate = Calendar.getInstance();
                _ganttComposite.setDate(currentDate, 0x1000000);
                BranchVisualizationView.this.moveFocus();
            }
        });
        bJumpToCurrentTimeRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Calendar currentDate = Calendar.getInstance();
                _ganttComposite.setDate(currentDate, 131072);
                BranchVisualizationView.this.moveFocus();
            }
        });
        zIn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                _ganttComposite.zoomIn();
                BranchVisualizationView.this.moveFocus();
            }
        });
        zOut.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                _ganttComposite.zoomOut();
                BranchVisualizationView.this.moveFocus();
            }
        });
        bShowPlanned.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                _ganttComposite.setShowPlannedDates(!_ganttComposite.isShowingPlannedDates());
                BranchVisualizationView.this.moveFocus();
            }
        });
        bShowDays.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                _ganttComposite.setShowDaysOnEvents(!_ganttComposite.isShowingDaysOnEvents());
                BranchVisualizationView.this.moveFocus();
            }
        });
    }

    private void moveFocus() {
        this.ganttChart.getGanttComposite().setFocus();
    }
}

