/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.messaging.Message;
import org.eclipse.osee.framework.messaging.internal.Activator;
import org.eclipse.osee.framework.messaging.internal.old.ApplicationDistributer;

public abstract class EndpointReceive {
    private ApplicationDistributer distributer;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public void onBind(ApplicationDistributer distributer) {
        this.distributer = distributer;
    }

    public void onUnbind(ApplicationDistributer distributer) {
        this.distributer = null;
    }

    protected void onReceive(final Message message) {
        if (this.distributer == null) {
            String errorMsg = String.format("We have recieved message [%s] from [%s], but have no active ApplicationDistributer available.", message.getId().toString(), message.getSource().toString());
            OseeLog.log(Activator.class, (Level)Level.WARNING, (String)errorMsg);
        } else {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    EndpointReceive.this.distributer.distribute(message);
                }
            });
        }
    }

    public abstract void start(Properties var1);

    public abstract void dispose();
}

