/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.branch.graph.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.framework.ui.branch.graph.model.IModelListener;

public class Model {
    private final Set<IModelListener> listeners = Collections.synchronizedSet(new HashSet());

    public void addListener(IModelListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IModelListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    protected List<IModelListener> getListeners() {
        return new ArrayList<IModelListener>(this.listeners);
    }

    protected void fireModelEvent() {
        this.fireModelEvent(null);
    }

    protected void fireModelEvent(Object object) {
        for (IModelListener listener : this.listeners) {
            listener.onModelEvent(object);
        }
    }
}

