/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.branch.graph.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.branch.graph.model.BranchModel;
import org.eclipse.osee.framework.ui.branch.graph.model.Node;
import org.eclipse.osee.framework.ui.branch.graph.model.StubBranchModel;
import org.eclipse.osee.framework.ui.branch.graph.model.TxData;
import org.eclipse.osee.framework.ui.branch.graph.model.TxModel;

public class GraphCache {
    private final BranchModel rootModel;
    private final Map<BranchId, BranchModel> branchToBranchModelMap = new HashMap<BranchId, BranchModel>();
    private final Map<Long, TxModel> txNumberToTxModelMap = new HashMap<Long, TxModel>();

    public GraphCache(BranchId rootBranch) {
        this.rootModel = this.getOrCreateBranchModel(rootBranch);
        this.rootModel.setDepth(0);
    }

    public BranchModel getRootModel() {
        return this.rootModel;
    }

    public List<Node> getNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.addAll(this.branchToBranchModelMap.values());
        nodes.addAll(this.txNumberToTxModelMap.values());
        return nodes;
    }

    protected void reset() {
        this.branchToBranchModelMap.clear();
        this.txNumberToTxModelMap.clear();
        this.rootModel.reset();
        this.rootModel.resetTxs();
        this.rootModel.setIsLoaded(false);
    }

    protected void addBranchModel(BranchModel model) {
        this.branchToBranchModelMap.put(model.getBranch(), model);
    }

    protected void addTxModel(TxModel model) {
        this.txNumberToTxModelMap.put(model.getRevision(), model);
    }

    protected void removeBranchModel(BranchId branch) {
        this.branchToBranchModelMap.remove(branch);
    }

    protected void removeTxModel(Long txId) {
        this.txNumberToTxModelMap.remove(txId);
    }

    public BranchModel getBranchModel(BranchId branch) {
        return this.branchToBranchModelMap.get(branch);
    }

    public TxModel getTxModel(Long txId) {
        return this.txNumberToTxModelMap.get(txId);
    }

    public Collection<BranchModel> getBranchModels() {
        return this.branchToBranchModelMap.values();
    }

    public Collection<TxModel> getTxModels() {
        return this.txNumberToTxModelMap.values();
    }

    protected TxModel getOrCreateTxModel(TxData txData) {
        TxModel toReturn = this.getTxModel(txData.getTxId());
        if (toReturn == null) {
            toReturn = new TxModel(txData);
            this.addTxModel(toReturn);
        }
        return toReturn;
    }

    protected BranchModel getOrCreateBranchModel(BranchId branch) {
        BranchModel toReturn = null;
        toReturn = branch.equals(StubBranchModel.STUB_BRANCH) ? this.getStubBranchModel() : this.getBranchModel(branch);
        if (toReturn == null) {
            toReturn = new BranchModel(branch);
            TransactionRecord headTransaction = TransactionManager.getTransaction((TransactionId)TransactionManager.getHeadTransaction((BranchId)branch));
            TransactionRecord baseTransaction = BranchManager.getBaseTransaction((BranchId)branch);
            this.addTxsToBranchModel(toReturn, baseTransaction);
            if (baseTransaction.equals((Object)headTransaction)) {
                this.addTxsToBranchModel(toReturn, headTransaction);
            }
            this.addBranchModel(toReturn);
        }
        return toReturn;
    }

    private void addTxsToBranchModel(BranchModel branchModel, TransactionRecord toAdd) {
        TxModel txModel = this.getOrCreateTxModel(TxData.createTxData(toAdd));
        branchModel.addTx(txModel);
    }

    public StubBranchModel getStubBranchModel() {
        StubBranchModel toReturn = (StubBranchModel)this.getBranchModel(StubBranchModel.STUB_BRANCH);
        if (toReturn == null) {
            toReturn = new StubBranchModel();
            this.addTxModel(toReturn.addTx(-1L));
            this.addBranchModel(toReturn);
        }
        return toReturn;
    }
}

