/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt.hex;

import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.osee.framework.ui.swt.FontManager;
import org.eclipse.osee.framework.ui.swt.hex.ByteColumnLabelProvider;
import org.eclipse.osee.framework.ui.swt.hex.HexEditingSupport;
import org.eclipse.osee.framework.ui.swt.hex.HexTableContentProvider;
import org.eclipse.osee.framework.ui.swt.hex.Highlighter;
import org.eclipse.osee.framework.ui.swt.hex.IHexTblHighlighter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class HexTable
extends Composite {
    private final TableViewer v;
    private final int bytesPerRow;

    public HexTable(Composite parent, int style, byte[] array, int bytesPerRow) {
        super(parent, 0);
        this.bytesPerRow = bytesPerRow;
        this.v = new TableViewer((Composite)this, 0x10010000 | style);
        this.v.setContentProvider((IContentProvider)new HexTableContentProvider(this.v, bytesPerRow));
        this.v.setUseHashlookup(true);
        TableColumnLayout layout = new TableColumnLayout();
        this.setLayout((Layout)layout);
        this.createAndConfigureColumns(this.v, layout, bytesPerRow);
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(this.v, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.v));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.v){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.v, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        this.v.setInput((Object)array);
        this.v.setItemCount((array.length + bytesPerRow - 1) / bytesPerRow);
        this.v.getTable().setHeaderVisible(false);
    }

    protected ByteColumnLabelProvider createByteColumnLabelProvider(int column) {
        return new ByteColumnLabelProvider(FontManager.getCourierNew8(), column);
    }

    protected HexEditingSupport createHexEditingSupport(int column) {
        return new HexEditingSupport(FontManager.getCourierNew8(), this.v, column);
    }

    public int getBytesPerRow() {
        return this.bytesPerRow;
    }

    protected abstract void createAndConfigureColumns(TableViewer var1, TableColumnLayout var2, int var3);

    public IHexTblHighlighter createHighlighter(int index, int length, Color color) {
        return new Highlighter((HexTableContentProvider)this.v.getContentProvider(), index, length, color);
    }

    public void dispose() {
        super.dispose();
    }
}

