/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt.hex;

import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.hex.AsciiColumnLabelProvider;
import org.eclipse.osee.framework.ui.swt.hex.DividerLabel;
import org.eclipse.osee.framework.ui.swt.hex.HexTable;
import org.eclipse.osee.framework.ui.swt.hex.IHexTblHighlighter;
import org.eclipse.osee.framework.ui.swt.hex.OffsetColumnLabelProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class BasicHexTable
extends HexTable {
    public BasicHexTable(Composite parent, byte[] array, int bytesPerRow) {
        super(parent, 2816, array, bytesPerRow);
    }

    @Override
    protected void createAndConfigureColumns(TableViewer v, TableColumnLayout layout, int bytesPerRow) {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)v, (int)2);
        TableViewerColumn column = new TableViewerColumn(v, 131072);
        column.setLabelProvider((CellLabelProvider)new OffsetColumnLabelProvider());
        column.getColumn().setText("Offset");
        column.getColumn().setResizable(false);
        column.getColumn().setMoveable(false);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(50));
        int i = 0;
        while (i < bytesPerRow) {
            TableViewerColumn c = new TableViewerColumn(v, 16384);
            c.setLabelProvider((CellLabelProvider)this.createByteColumnLabelProvider(i));
            c.getColumn().setText(Integer.toHexString(i));
            c.getColumn().setResizable(false);
            c.getColumn().setMoveable(false);
            c.setEditingSupport((EditingSupport)this.createHexEditingSupport(i));
            layout.setColumnData((Widget)c.getColumn(), (ColumnLayoutData)new ColumnPixelData(26));
            ++i;
        }
        TableViewerColumn divider = new TableViewerColumn(v, 16384);
        divider.getColumn().setResizable(false);
        divider.setLabelProvider((CellLabelProvider)new DividerLabel());
        layout.setColumnData((Widget)divider.getColumn(), (ColumnLayoutData)new ColumnPixelData(1));
        int i2 = 0;
        while (i2 < bytesPerRow) {
            TableViewerColumn c = new TableViewerColumn(v, 16384);
            c.setLabelProvider((CellLabelProvider)new AsciiColumnLabelProvider(i2));
            c.getColumn().setResizable(false);
            c.getColumn().setMoveable(false);
            layout.setColumnData((Widget)c.getColumn(), (ColumnLayoutData)new ColumnPixelData(20));
            ++i2;
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setSize(500, 400);
        shell.setLayout((Layout)new FillLayout());
        byte[] array = new byte[702];
        int i = 0;
        while (i < array.length) {
            array[i] = (byte)i;
            ++i;
        }
        int index = 50;
        String str = "this is a test";
        array[48] = 3;
        array[49] = 3;
        byte[] byArray = str.getBytes();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte b;
            array[index] = b = byArray[n2];
            ++index;
            ++n2;
        }
        array[index] = 3;
        array[index + 1] = 3;
        BasicHexTable t = new BasicHexTable((Composite)shell, array, 16);
        shell.open();
        IHexTblHighlighter yellowHL = t.createHighlighter(30, 3, Displays.getSystemColor(7));
        IHexTblHighlighter blueHL = t.createHighlighter(50, str.length(), Displays.getSystemColor(9));
        yellowHL.highlight();
        blueHL.highlight();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

