/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import java.util.regex.Pattern;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public final class Widgets {
    private static Composite targetContainer;

    public static void setTargetContainer(Composite target) {
        targetContainer = target;
    }

    public static GridData positionGridItem(Control control, boolean grabHExcess, boolean grabVExcess, int halign, int valign, int hspan) {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = grabHExcess;
        gd.grabExcessVerticalSpace = grabVExcess;
        gd.horizontalAlignment = halign;
        gd.horizontalSpan = hspan;
        gd.verticalAlignment = valign;
        control.setLayoutData((Object)gd);
        return gd;
    }

    public static GridData positionGridItem(Control control, boolean grabHExcess, boolean grabVExcess, int halign, int valign, int hspan, int vspan) {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = grabHExcess;
        gd.grabExcessVerticalSpace = grabVExcess;
        gd.horizontalAlignment = halign;
        gd.horizontalSpan = hspan;
        gd.verticalAlignment = valign;
        gd.verticalSpan = vspan;
        control.setLayoutData((Object)gd);
        return gd;
    }

    public static GridData positionGridItem(Control control, boolean grabHExcess, int halign, int valign, int hspan) {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = grabHExcess;
        gd.horizontalAlignment = halign;
        gd.horizontalSpan = hspan;
        gd.verticalAlignment = valign;
        control.setLayoutData((Object)gd);
        return gd;
    }

    public static GridData positionGridItem(Control control, boolean grabHExcess, int halign, int valign) {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = grabHExcess;
        gd.horizontalAlignment = halign;
        gd.verticalAlignment = valign;
        control.setLayoutData((Object)gd);
        return gd;
    }

    public static GridData positionGridItem(Control control, boolean grabHExcess, int halign, int valign, int hspan, int vspan) {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = grabHExcess;
        gd.horizontalAlignment = halign;
        gd.horizontalSpan = hspan;
        gd.verticalAlignment = valign;
        gd.verticalSpan = vspan;
        control.setLayoutData((Object)gd);
        return gd;
    }

    public static GridData positionGridItem(Control control, boolean grabHExcess, int halign, int valign, int hspan, int vspan, int width) {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = grabHExcess;
        gd.horizontalAlignment = halign;
        gd.horizontalSpan = hspan;
        gd.verticalAlignment = valign;
        gd.verticalSpan = vspan;
        gd.widthHint = width;
        control.setLayoutData((Object)gd);
        return gd;
    }

    public static GridData positionGridItem(Control control, boolean grabHExcess, int halign, int valign, int hspan, int vspan, int width, int height) {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = grabHExcess;
        gd.horizontalAlignment = halign;
        gd.horizontalSpan = hspan;
        gd.verticalAlignment = valign;
        gd.verticalSpan = vspan;
        gd.heightHint = height;
        gd.widthHint = width;
        control.setLayoutData((Object)gd);
        return gd;
    }

    public static GridData positionGridItem(Control control, boolean grabHExcess, boolean grabVExcess, int halign, int valign, int hspan, int vspan, int width, int height) {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = grabHExcess;
        gd.grabExcessVerticalSpace = grabVExcess;
        gd.horizontalAlignment = halign;
        gd.horizontalSpan = hspan;
        gd.verticalAlignment = valign;
        gd.verticalSpan = vspan;
        gd.heightHint = height;
        gd.widthHint = width;
        control.setLayoutData((Object)gd);
        return gd;
    }

    public static Text createTxt(String defaultTxt, int limit) {
        Text txt = new Text(targetContainer, 2048);
        txt.setTextLimit(limit);
        txt.setText(defaultTxt);
        return txt;
    }

    public static Text createTxt(Composite comp, String defaultTxt, int limit) {
        Text txt = new Text(comp, 2048);
        txt.setTextLimit(limit);
        txt.setText(defaultTxt);
        return txt;
    }

    public static Text createTxt(Composite comp, int style, String defaultTxt, int limit) {
        Text txt = new Text(comp, style);
        txt.setTextLimit(limit);
        txt.setText(defaultTxt);
        return txt;
    }

    public static Text createTxt(Composite comp, int style, String defaultTxt) {
        Text txt = new Text(comp, style);
        txt.setText(defaultTxt);
        return txt;
    }

    public static Text createNumericTxt(Composite comp, String defaultTxt, int limit) {
        return Widgets.createNumericTxt(comp, defaultTxt, limit, 2048);
    }

    public static Text createNumericTxt(Composite comp, String defaultTxt, int limit, int style) {
        final Text txtBox = new Text(comp, style);
        txtBox.setTextLimit(limit);
        txtBox.setText(defaultTxt);
        txtBox.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                StringBuilder str = new StringBuilder(txtBox.getText());
                if (e.start == e.end) {
                    str.insert(e.start, e.text);
                } else {
                    str.replace(e.start, e.end, e.text);
                }
                String txt = str.toString();
                e.doit = txt.matches("\\d*");
            }
        });
        return txtBox;
    }

    public static Text createDecimalText(Composite comp, String defaultTxt, int min, int max, int limit, int style) {
        final Text txtBox = new Text(comp, style);
        txtBox.setTextLimit(limit);
        txtBox.setText(defaultTxt);
        txtBox.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                StringBuilder str = new StringBuilder(txtBox.getText());
                if (e.start == e.end) {
                    str.insert(e.start, e.text);
                } else {
                    str.replace(e.start, e.end, e.text);
                }
                String txt = str.toString();
                e.doit = txt.matches("\\d*");
            }
        });
        return txtBox;
    }

    public static Label createLbl(String txt, int align) {
        Label lbl = new Label(targetContainer, align);
        lbl.setText(txt);
        return lbl;
    }

    public static Label createLbl(Composite item, String txt, int align) {
        Label lbl = new Label(item, align);
        lbl.setText(txt);
        return lbl;
    }

    public static Group createGrp(Composite item, String txt) {
        Group grp = new Group(item, 0);
        grp.setText(txt);
        return grp;
    }

    public static Button createBtn(int style, String txt) {
        Button btn = new Button(targetContainer, style);
        btn.setText(txt);
        return btn;
    }

    public static Button createBtn(Composite comp, int style, String txt) {
        Button btn = new Button(comp, style);
        btn.setText(txt);
        return btn;
    }

    public static Button createBtn(Composite comp, int style, String txt, SelectionListener listener) {
        Button btn = new Button(comp, style);
        btn.setText(txt);
        btn.addSelectionListener(listener);
        return btn;
    }

    public static Group createGrp(String txt) {
        Group grp = new Group(targetContainer, 0);
        grp.setText(txt);
        return grp;
    }

    public static GridLayout setGridLayout(Composite item, int numColumns, int columnSpacing) {
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.horizontalSpacing = columnSpacing;
        item.setLayout((Layout)layout);
        return layout;
    }

    public static RowLayout setRowLayout(Composite item, int style, boolean wrap, boolean pack) {
        RowLayout layout = new RowLayout(style);
        layout.wrap = wrap;
        layout.pack = pack;
        item.setLayout((Layout)layout);
        return layout;
    }

    public static RowLayout setRowLayout(Composite item, int style, boolean wrap, boolean pack, boolean fill) {
        RowLayout layout = Widgets.setRowLayout(item, style, wrap, pack);
        layout.fill = fill;
        layout.center = true;
        return layout;
    }

    public static FillLayout setFillLayout(Composite item, int style) {
        FillLayout layout = new FillLayout(style);
        item.setLayout((Layout)layout);
        return layout;
    }

    public static void setGridLayout(Composite item, int numColumns, int columnSpacing, boolean equal, int hpad) {
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.horizontalSpacing = columnSpacing;
        layout.makeColumnsEqualWidth = equal;
        layout.marginLeft = hpad;
        layout.marginRight = hpad;
        item.setLayout((Layout)layout);
    }

    public static GridLayout setGridLayout(Composite item, int numColumns, int columnSpacing, int verticalSpacing, boolean equal, int hpad) {
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.horizontalSpacing = columnSpacing;
        layout.makeColumnsEqualWidth = equal;
        layout.marginLeft = hpad;
        layout.marginRight = hpad;
        layout.verticalSpacing = verticalSpacing;
        layout.marginHeight = 0;
        item.setLayout((Layout)layout);
        return layout;
    }

    public static GridLayout setGridLayout(Composite item, int numColumns, int columnSpacing, int verticalSpacing, boolean equal, int hpad, int vpad) {
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.horizontalSpacing = columnSpacing;
        layout.makeColumnsEqualWidth = equal;
        layout.marginLeft = hpad;
        layout.marginRight = hpad;
        layout.marginTop = vpad;
        layout.marginBottom = vpad;
        layout.verticalSpacing = verticalSpacing;
        layout.marginHeight = 0;
        item.setLayout((Layout)layout);
        return layout;
    }

    public static Combo createCombo(int style, Object[] list) {
        Combo cbx = new Combo(targetContainer, style);
        Object[] objectArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            cbx.add(element.toString());
            ++n2;
        }
        cbx.select(0);
        return cbx;
    }

    public static Combo createCombo(Composite item, int style, Object[] list) {
        Combo cbx = new Combo(item, style);
        Object[] objectArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            cbx.add(element.toString());
            ++n2;
        }
        cbx.select(0);
        return cbx;
    }

    public static Group createRadioGrp(String txt, int columns, Object[] items) {
        final Group grp = new Group(targetContainer, 0);
        grp.setText(txt);
        Widgets.setGridLayout((Composite)grp, columns, 10);
        int count = 0;
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            final Button rdo = new Button((Composite)grp, 16);
            rdo.setText(obj.toString());
            rdo.setData(obj);
            rdo.setSelection(count == 0);
            Widgets.positionGridItem((Control)rdo, false, 1, 0x1000000);
            rdo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (rdo.getSelection()) {
                        grp.setData(rdo.getData());
                    }
                }
            });
            ++count;
            ++n2;
        }
        return grp;
    }

    public static Group createRadioGrp(String txt, int columns, Object[] items, Button[] btns) {
        final Group grp = new Group(targetContainer, 0);
        grp.setText(txt);
        Widgets.setGridLayout((Composite)grp, columns, 10);
        int count = 0;
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Button rdo;
            Object obj = objectArray[n2];
            btns[count] = rdo = new Button((Composite)grp, 16);
            rdo.setText(obj.toString());
            rdo.setData(obj);
            rdo.setSelection(count == 0);
            Widgets.positionGridItem((Control)rdo, false, 1, 0x1000000);
            rdo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (rdo.getSelection()) {
                        grp.setData(rdo.getData());
                        System.out.println(grp.getData().toString());
                    }
                }
            });
            ++count;
            ++n2;
        }
        return grp;
    }

    public static Group createRadioGrp(Composite comp, String txt, int columns, Object[] items) {
        final Group grp = new Group(comp, 0);
        grp.setText(txt);
        Widgets.setGridLayout((Composite)grp, columns, 10);
        int count = 0;
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            final Object item = objectArray[n2];
            final Button rdo = new Button((Composite)grp, 16);
            rdo.setText(item.toString());
            rdo.setSelection(count == 0);
            Widgets.positionGridItem((Control)rdo, false, 1, 0x1000000);
            rdo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (rdo.getSelection()) {
                        grp.setData(item);
                    }
                }
            });
            ++count;
            ++n2;
        }
        return grp;
    }

    public static Group createRadioGrp(Composite comp, String txt, int columns, Object[] items, Button[] btns) {
        final Group grp = new Group(comp, 0);
        grp.setText(txt);
        Widgets.setGridLayout((Composite)grp, columns, 5);
        int count = 0;
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Button rdo;
            final Object obj = objectArray[n2];
            btns[count] = rdo = new Button((Composite)grp, 16);
            rdo.setText(obj.toString());
            rdo.setSelection(count == 0);
            Widgets.positionGridItem((Control)rdo, false, 0x1000000, 0x1000000);
            rdo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (rdo.getSelection()) {
                        grp.setData(obj);
                        System.out.println(grp.getData().toString());
                    }
                }
            });
            ++count;
            ++n2;
        }
        return grp;
    }

    public static void attachToParent(Control control, int edge, int percent, int offset) {
        Widgets.attachToParent(control, edge, percent, offset, -1, -1);
    }

    public static void attachToParent(Control control, int edge, int percent, int offset, int width, int height) {
        Object ld = control.getLayoutData();
        FormData fd = ld != null ? (FormData)ld : new FormData();
        switch (edge) {
            case 16384: {
                fd.left = new FormAttachment(percent, offset);
                break;
            }
            case 131072: {
                fd.right = new FormAttachment(percent, offset);
                break;
            }
            case 128: {
                fd.top = new FormAttachment(percent, offset);
                break;
            }
            case 1024: {
                fd.bottom = new FormAttachment(percent, offset);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid edge specified");
            }
        }
        fd.width = width;
        fd.height = height;
        control.setLayoutData((Object)fd);
    }

    public static void attachToControl(Control control, Control itemToAttachTo, int edge, int itemToAttachToEdge, int offset) {
        Widgets.attachToControl(control, itemToAttachTo, edge, itemToAttachToEdge, offset, -1, -1);
    }

    public static void attachToControl(Control control, Control itemToAttachTo, int edge, int itemToAttachToEdge, int offset, int width, int height) {
        Object ld = control.getLayoutData();
        FormData fd = ld != null ? (FormData)ld : new FormData();
        switch (edge) {
            case 16384: {
                fd.left = new FormAttachment(itemToAttachTo, offset, itemToAttachToEdge);
                break;
            }
            case 131072: {
                fd.right = new FormAttachment(itemToAttachTo, offset, itemToAttachToEdge);
                break;
            }
            case 128: {
                fd.top = new FormAttachment(itemToAttachTo, offset, itemToAttachToEdge);
                break;
            }
            case 1024: {
                fd.bottom = new FormAttachment(itemToAttachTo, offset, itemToAttachToEdge);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid edge specified");
            }
        }
        fd.width = width;
        fd.height = height;
        control.setLayoutData((Object)fd);
    }

    public static void setFormLayout(Composite composite) {
        composite.setLayout((Layout)new FormLayout());
    }

    public static void setFormLayout(Composite composite, int marginWidth, int marginHeight) {
        FormLayout fl = new FormLayout();
        fl.marginWidth = marginWidth;
        fl.marginHeight = marginHeight;
        composite.setLayout((Layout)fl);
    }

    public static <T extends Widget> void disposeWidgets(T ... widgets) {
        if (widgets == null) {
            return;
        }
        T[] TArray = widgets;
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            T widget = TArray[n2];
            if (widget != null && !widget.isDisposed()) {
                widget.dispose();
            }
            ++n2;
        }
    }

    public static void disposeWidget(Widget widget) {
        if (Widgets.isAccessible(widget)) {
            if (widget instanceof Composite) {
                Control[] controlArray = ((Composite)widget).getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    Widgets.disposeWidget((Widget)child);
                    ++n2;
                }
            }
            widget.dispose();
        }
    }

    public static boolean isAccessible(Widget widget) {
        return widget != null && !widget.isDisposed();
    }

    public static abstract class IntegerTextEntryHandler
    implements FocusListener,
    VerifyListener,
    TraverseListener {
        private static final Pattern NEGATIVE_PATTERN = Pattern.compile("\\-?|\\-?\\d+");
        private static final Pattern NON_NEGATIVE_PATTERN = Pattern.compile("\\d+");
        private String currentTxt;
        private final Pattern pattern;
        private final Text txt;
        private final StringBuilder str;

        public IntegerTextEntryHandler(Text txt, boolean allowNegatives, int limit) {
            this.txt = txt;
            txt.addFocusListener((FocusListener)this);
            txt.addVerifyListener((VerifyListener)this);
            txt.addTraverseListener((TraverseListener)this);
            this.str = new StringBuilder(limit + 2);
            this.pattern = allowNegatives ? NEGATIVE_PATTERN : NON_NEGATIVE_PATTERN;
        }

        public void verifyText(VerifyEvent e) {
            String text = this.txt.getText();
            this.str.replace(0, text.length(), text);
            this.str.setLength(text.length());
            if (e.start == e.end) {
                this.str.insert(e.start, e.text);
            } else {
                this.str.replace(e.start, e.end, e.text);
            }
            String result = this.str.toString();
            e.doit = result.equals("") ? true : this.verifyValue(result);
        }

        public void focusGained(FocusEvent e) {
            this.currentTxt = this.txt.getText();
            this.txt.selectAll();
        }

        public void focusLost(FocusEvent e) {
            try {
                long value = Long.parseLong(this.txt.getText());
                this.applyValue(value);
            }
            catch (NumberFormatException numberFormatException) {
                this.txt.setText(this.currentTxt);
            }
        }

        public abstract void applyValue(long var1);

        public Long getPreviousValue() {
            if (!this.currentTxt.equals("")) {
                return Long.parseLong(this.currentTxt);
            }
            return null;
        }

        public void keyTraversed(TraverseEvent e) {
            switch (e.detail) {
                case 2: {
                    this.txt.setText(this.currentTxt);
                    break;
                }
                case 4: {
                    try {
                        Long value = Long.parseLong(this.txt.getText());
                        this.applyValue(value);
                        this.currentTxt = this.txt.getText();
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.txt.setText(this.currentTxt);
                    }
                }
            }
        }

        private boolean verifyValue(String value) {
            return this.pattern.matcher(value).matches();
        }
    }

    public static abstract class RealNumberTextEntryHandler
    implements FocusListener,
    VerifyListener,
    TraverseListener {
        private static final Pattern NON_NEGATIVE_PATTERN = Pattern.compile("\\d*\\.?\\d*");
        private static final Pattern NEGATIVE_PATTERN = Pattern.compile("[\\-.]?|\\-?\\d*\\.?\\d*");
        private String currentTxt;
        private final Pattern pattern;
        private final Text txt;
        private final StringBuilder str;

        public RealNumberTextEntryHandler(Text txt, boolean allowNegatives, int limit) {
            this.txt = txt;
            txt.addFocusListener((FocusListener)this);
            txt.addVerifyListener((VerifyListener)this);
            txt.addTraverseListener((TraverseListener)this);
            this.str = new StringBuilder(limit + 2);
            this.pattern = allowNegatives ? NEGATIVE_PATTERN : NON_NEGATIVE_PATTERN;
        }

        public void verifyText(VerifyEvent e) {
            String text = this.txt.getText();
            this.str.replace(0, text.length(), text);
            this.str.setLength(text.length());
            if (e.start == e.end) {
                this.str.insert(e.start, e.text);
            } else {
                this.str.replace(e.start, e.end, e.text);
            }
            String result = this.str.toString();
            e.doit = result.equals("") ? true : this.verifyValue(result);
        }

        public void focusGained(FocusEvent e) {
            this.currentTxt = this.txt.getText();
            this.txt.selectAll();
        }

        public void focusLost(FocusEvent e) {
            try {
                double value = Double.parseDouble(this.txt.getText());
                this.applyValue(value);
            }
            catch (NumberFormatException numberFormatException) {
                this.txt.setText(this.currentTxt);
            }
        }

        public Double getPreviousValue() {
            if (!this.currentTxt.equals("")) {
                return Double.parseDouble(this.currentTxt);
            }
            return null;
        }

        public abstract void applyValue(double var1);

        public void keyTraversed(TraverseEvent e) {
            switch (e.detail) {
                case 2: {
                    this.txt.setText(this.currentTxt);
                    break;
                }
                case 4: {
                    try {
                        double value = Double.parseDouble(this.txt.getText());
                        this.applyValue(value);
                        this.currentTxt = this.txt.getText();
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.txt.setText(this.currentTxt);
                    }
                }
            }
        }

        private boolean verifyValue(String value) {
            return this.pattern.matcher(value).matches();
        }
    }
}

