/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import org.eclipse.osee.framework.ui.swt.CursorManager;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class HyperLinkLabel {
    private boolean hyperEnabled = true;
    private Label label = null;
    protected int marginWidth = 1;
    protected int marginHeight = 1;
    MouseTrackListener listener = new MouseTrackAdapter(){

        public void mouseEnter(MouseEvent e) {
            HyperLinkLabel.this.label.setCursor(CursorManager.getCursor(21));
        }

        public void mouseExit(MouseEvent e) {
            HyperLinkLabel.this.label.setCursor(null);
        }
    };

    public HyperLinkLabel(Composite parent, int style) {
        this(null, parent, style, null);
    }

    public HyperLinkLabel(FormToolkit toolkit, Composite parent, int style) {
        this(toolkit, parent, style, null);
    }

    public HyperLinkLabel(FormToolkit toolkit, Composite parent, int style, String text) {
        this.label = new Label(parent, style);
        if (text != null) {
            this.label.setText(text);
        }
        if (toolkit != null) {
            toolkit.adapt((Control)this.label, true, true);
        }
        this.refresh();
    }

    public static void adapt(final Label label) {
        label.setForeground(Displays.getSystemColor(9));
        label.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                label.setCursor(CursorManager.getCursor(21));
            }

            public void mouseExit(MouseEvent e) {
                label.setCursor(null);
            }
        });
    }

    public void refresh() {
        if (this.hyperEnabled) {
            this.label.setForeground(Displays.getSystemColor(9));
            this.label.removeMouseTrackListener(this.listener);
            this.label.addMouseTrackListener(this.listener);
        } else {
            this.label.setForeground(Displays.getSystemColor(2));
            this.label.removeMouseTrackListener(this.listener);
        }
    }

    public boolean isHyperEnabled() {
        return this.hyperEnabled;
    }

    public void setHyperEnabled(boolean hyperEnabled) {
        this.hyperEnabled = hyperEnabled;
        this.refresh();
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public void addListener(int mouseup, Listener listener) {
        this.label.addListener(mouseup, listener);
    }
}

