/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import org.eclipse.osee.framework.ui.swt.ITabFolderItem;
import org.eclipse.osee.framework.ui.swt.TabFolderItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class EnhancedTabFolder
implements ITabFolderItem {
    private final TabFolder folder;
    private TabFolderItem previousItem;

    public EnhancedTabFolder(Composite parent, int style) {
        this.folder = new TabFolder(parent, style);
        this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabFolderItem item = (TabFolderItem)((TabItem)event.item).getControl();
                if (item == EnhancedTabFolder.this.previousItem) {
                    return;
                }
                if (EnhancedTabFolder.this.previousItem != null) {
                    EnhancedTabFolder.this.previousItem.OnTabDeselected();
                }
                item.OnTabSelected();
                EnhancedTabFolder.this.previousItem = item;
            }
        });
        this.folder.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 16: 
                    case 64: {
                        System.out.println("Next tab selected");
                        break;
                    }
                    case 8: {
                        System.out.println("previous tab selected");
                    }
                }
            }
        });
    }

    public void setSelection(int index) {
        int selected = this.folder.getSelectionIndex();
        if (selected != -1) {
            this.previousItem = (TabFolderItem)this.folder.getItem(selected).getControl();
        }
        this.folder.setSelection(index);
    }

    public TabFolderItem getSelection() {
        int selected = this.folder.getSelectionIndex();
        if (selected != -1) {
            return (TabFolderItem)this.folder.getItem(selected).getControl();
        }
        return null;
    }

    public TabFolder getFolder() {
        return this.folder;
    }

    public void addTab(String tabText, ITabFolderItem tab) {
        TabItem item = new TabItem(this.folder, 0);
        item.setControl((Control)tab);
        item.setText(tabText);
    }

    public void addTab(String tabText, String toolTip, ITabFolderItem tab) {
        TabItem item = new TabItem(this.folder, 0);
        item.setControl((Control)tab);
        item.setText(tabText);
        item.setToolTipText(toolTip);
    }

    @Override
    public void OnTabDeselected() {
        int index = this.folder.getSelectionIndex();
        if (index != -1) {
            ((TabFolderItem)this.folder.getItem(index).getControl()).OnTabSelected();
        }
    }

    @Override
    public void OnTabSelected() {
        int index = this.folder.getSelectionIndex();
        if (index != -1) {
            ((TabFolderItem)this.folder.getItem(index).getControl()).OnTabDeselected();
        }
    }
}

