/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.world.IWorldEditorProvider;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorSimpleProvider;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.swt.CursorManager;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class WorldEditorProvider
implements IWorldEditorProvider {
    protected XNavigateComposite.TableLoadOption[] tableLoadOptions;
    protected CustomizeData customizeData;
    private WorldEditor worldEditor;
    private boolean loading;

    public WorldEditorProvider(CustomizeData customizeData, XNavigateComposite.TableLoadOption[] tableLoadOptions) {
        this.customizeData = customizeData;
        this.tableLoadOptions = (XNavigateComposite.TableLoadOption[])tableLoadOptions.clone();
    }

    @Override
    public String getSelectedName(WorldSearchItem.SearchType searchType) {
        return this.getName();
    }

    @Override
    public IAtsVersion getTargetedVersionArtifact() {
        return null;
    }

    @Override
    public void setTableLoadOptions(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        this.tableLoadOptions = tableLoadOptions;
    }

    @Override
    public void setCustomizeData(CustomizeData customizeData) {
        this.customizeData = customizeData;
    }

    @Override
    public void run(WorldEditor worldEditor, WorldSearchItem.SearchType searchType, boolean forcePend) {
        this.worldEditor = worldEditor;
        boolean pend = Arrays.asList(this.tableLoadOptions).contains(XNavigateComposite.TableLoadOption.ForcePend) || forcePend;
        worldEditor.getWorldComposite().getXViewer().setForcePend(pend);
        if (this.loading) {
            AWorkbench.popup((String)"Already Loading, Please Wait");
            return;
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (TreeItem item : worldEditor.getWorldComposite().getXViewer().getVisibleItems()) {
            if (!(item.getData() instanceof Artifact)) continue;
            artifacts.add((Artifact)item.getData());
        }
        ArtifactQuery.reloadArtifacts(artifacts);
        LoadTableJob job = null;
        job = new LoadTableJob(worldEditor, this, searchType, this.tableLoadOptions, pend);
        job.setUser(false);
        job.setPriority(30);
        job.schedule();
        if (pend) {
            try {
                worldEditor.getWorldComposite().getXViewer().setForcePend(true);
                job.join();
            }
            catch (InterruptedException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
    }

    public void setLoading(final boolean loading) {
        this.loading = loading;
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Widgets.isAccessible((Widget)WorldEditorProvider.this.worldEditor.getWorldComposite())) {
                    if (loading) {
                        WorldEditorProvider.this.worldEditor.getWorldComposite().setCursor(CursorManager.getCursor((int)1));
                    } else {
                        WorldEditorProvider.this.worldEditor.getWorldComposite().setCursor(null);
                    }
                }
            }
        });
    }

    private class LoadTableJob
    extends Job {
        private final boolean cancel = false;
        private final WorldSearchItem.SearchType searchType;
        private final WorldEditor worldEditor;
        private final XNavigateComposite.TableLoadOption[] tableLoadOptions;
        private final boolean forcePend;
        private final WorldEditorProvider worldEditorProvider;

        public LoadTableJob(WorldEditor worldEditor, WorldEditorProvider worldEditorProvider2, WorldSearchItem.SearchType searchType, XNavigateComposite.TableLoadOption[] tableLoadOptions, boolean forcePend) {
            super("Loading \"" + worldEditorProvider2.getSelectedName(searchType) + "\"...");
            this.cancel = false;
            this.worldEditor = worldEditor;
            this.worldEditorProvider = worldEditorProvider2;
            this.searchType = searchType;
            this.tableLoadOptions = (XNavigateComposite.TableLoadOption[])tableLoadOptions.clone();
            this.forcePend = forcePend;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (WorldEditorProvider.this.loading) {
                return new Status(4, "org.eclipse.osee.ats.ide", -1, "Already Loading, Please Wait", null);
            }
            String selectedName = "";
            try {
                WorldEditorProvider.this.setLoading(true);
                selectedName = this.worldEditorProvider.getSelectedName(this.searchType);
                this.worldEditor.setEditorTitle(selectedName != null ? selectedName : this.worldEditorProvider.getName());
                this.worldEditor.setTableTitle("Loading \"" + (selectedName != null ? selectedName : "") + "\"...", false);
                this.worldEditor.getWorldComposite().getXViewer().clear(this.forcePend);
                List artifacts = Collections.castAll(WorldEditorProvider.this.performSearch(this.searchType));
                if (artifacts.isEmpty()) {
                    monitor.done();
                    this.worldEditor.setTableTitle("No Results Found - " + selectedName, true);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                try {
                    Artifact expandToArtifact = null;
                    if (this.worldEditorProvider instanceof WorldEditorSimpleProvider) {
                        WorldEditorSimpleProvider provider = (WorldEditorSimpleProvider)this.worldEditorProvider;
                        expandToArtifact = provider.getExpandToArtifact();
                    }
                    this.worldEditor.getWorldComposite().load(selectedName != null ? selectedName : "", (Collection<? extends Artifact>)artifacts, WorldEditorProvider.this.customizeData, expandToArtifact, this.tableLoadOptions);
                }
                catch (Exception ex) {
                    String str = "Exception occurred.";
                    if (Strings.isValid((String)ex.getLocalizedMessage())) {
                        str = String.valueOf(str) + " => " + ex.getLocalizedMessage();
                    }
                    this.worldEditor.getWorldComposite().setTableTitle("Searching Error - " + selectedName, false);
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    monitor.done();
                    Status status = new Status(4, "org.eclipse.osee.ats.ide", -1, str, null);
                    return status;
                }
            }
            finally {
                WorldEditorProvider.this.setLoading(false);
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

