/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.search.AtsSearchWorkflowSearchItem;
import org.eclipse.osee.ats.ide.world.IWorldEditorProvider;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorInputFactory;
import org.eclipse.osee.ats.ide.world.WorldEditorParameterSearchItemProvider;
import org.eclipse.osee.ats.ide.world.WorldEditorReloadProvider;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.framework.core.data.Adaptable;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class WorldEditorInput
implements IEditorInput,
IPersistableElement,
Adaptable {
    IWorldEditorProvider iWorldEditorProvider;
    WorldEditor editor;

    public int hashCode() {
        return this.iWorldEditorProvider.hashCode();
    }

    public IWorldEditorProvider getIWorldEditorProvider() {
        return this.iWorldEditorProvider;
    }

    public WorldEditorInput(IWorldEditorProvider iWorldEditorProvider) {
        this.iWorldEditorProvider = iWorldEditorProvider;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WorldEditorInput)) {
            return false;
        }
        WorldEditorInput castObj = (WorldEditorInput)obj;
        return castObj.iWorldEditorProvider.equals(this.iWorldEditorProvider);
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.GLOBE);
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public void saveState(IMemento memento) {
        WorldEditorInputFactory.saveState(memento, this);
    }

    public String getFactoryId() {
        return "org.eclipse.osee.ats.ide.WorldEditorInputFactory";
    }

    public String getToolTipText() {
        try {
            return this.iWorldEditorProvider.getName();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return "Exception getting name: " + ex.getLocalizedMessage();
        }
    }

    public String getName() {
        try {
            return this.iWorldEditorProvider.getName();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return "Exception getting name: " + ex.getLocalizedMessage();
        }
    }

    public String getIdString() {
        List<Artifact> artifactIds;
        if (this.editor.isReloadTabShown() && this.iWorldEditorProvider instanceof WorldEditorReloadProvider) {
            WorldEditorReloadProvider provider = (WorldEditorReloadProvider)this.iWorldEditorProvider;
            artifactIds = provider.getValidArtIds();
        } else {
            artifactIds = this.editor.getLoadedArtifacts();
        }
        return Collections.toString(artifactIds, (String)",", Id::getIdString);
    }

    public WorldEditor getEditor() {
        return this.editor;
    }

    public void setEditor(WorldEditor editor) {
        this.editor = editor;
    }

    public boolean isReload() {
        boolean reload = false;
        if (this.iWorldEditorProvider instanceof WorldEditorReloadProvider) {
            WorldEditorReloadProvider worldEditorReloadProvider = (WorldEditorReloadProvider)this.iWorldEditorProvider;
            reload = worldEditorReloadProvider.isReload();
        }
        return reload;
    }

    public BranchId getBranch() {
        BranchId branch = BranchId.SENTINEL;
        if (this.editor.isReloadTabShown() && this.iWorldEditorProvider instanceof WorldEditorReloadProvider) {
            WorldEditorReloadProvider provider = (WorldEditorReloadProvider)this.iWorldEditorProvider;
            branch = provider.getBranch();
        } else if (!this.editor.getLoadedArtifacts().isEmpty()) {
            branch = this.editor.getLoadedArtifacts().iterator().next().getBranch();
        }
        return branch;
    }

    public Long getAtsSearchId() {
        WorldSearchItem worldSearchItem;
        if (this.iWorldEditorProvider instanceof WorldEditorParameterSearchItemProvider && (worldSearchItem = ((WorldEditorParameterSearchItemProvider)this.iWorldEditorProvider).getWorldSearchItem()) instanceof AtsSearchWorkflowSearchItem) {
            return ((AtsSearchWorkflowSearchItem)worldSearchItem).getSearchId();
        }
        return 0L;
    }

    public String getAtsSearchNamespace() {
        WorldSearchItem worldSearchItem;
        if (this.iWorldEditorProvider instanceof WorldEditorParameterSearchItemProvider && (worldSearchItem = ((WorldEditorParameterSearchItemProvider)this.iWorldEditorProvider).getWorldSearchItem()) instanceof AtsSearchWorkflowSearchItem) {
            return ((AtsSearchWorkflowSearchItem)worldSearchItem).getNamespace();
        }
        return null;
    }
}

