/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.actions.ISelectedTeamWorkflowArtifacts;
import org.eclipse.osee.ats.ide.actions.OpenNewAtsTaskEditorAction;
import org.eclipse.osee.ats.ide.actions.OpenNewAtsTaskEditorSelected;
import org.eclipse.osee.ats.ide.actions.OpenNewAtsWorldEditorAction;
import org.eclipse.osee.ats.ide.actions.OpenNewAtsWorldEditorSelectedAction;
import org.eclipse.osee.ats.ide.config.AtsBulkLoad;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.task.ITaskEditorProvider;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.world.IAtsWorldArtifactEventColumn;
import org.eclipse.osee.ats.ide.world.IWorldEditor;
import org.eclipse.osee.ats.ide.world.IWorldEditorProvider;
import org.eclipse.osee.ats.ide.world.IWorldViewerEventHandler;
import org.eclipse.osee.ats.ide.world.WorldContentProvider;
import org.eclipse.osee.ats.ide.world.WorldLabelProvider;
import org.eclipse.osee.ats.ide.world.WorldViewDragAndDrop;
import org.eclipse.osee.ats.ide.world.WorldXViewer;
import org.eclipse.osee.ats.ide.world.WorldXViewerEventManager;
import org.eclipse.osee.ats.ide.world.WorldXViewerFactory;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.skynet.action.RefreshAction;
import org.eclipse.osee.framework.ui.skynet.render.RendererManager;
import org.eclipse.osee.framework.ui.skynet.util.DbConnectionExceptionComposite;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.IOseeTreeReportProvider;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class WorldComposite
extends Composite
implements IOseeTreeReportProvider,
ISelectedTeamWorkflowArtifacts,
ISelectedAtsArtifacts,
IWorldViewerEventHandler,
OpenNewAtsWorldEditorAction.IOpenNewAtsWorldEditorHandler,
OpenNewAtsWorldEditorSelectedAction.IOpenNewAtsWorldEditorSelectedHandler,
OpenNewAtsTaskEditorAction.IOpenNewAtsTaskEditorHandler,
OpenNewAtsTaskEditorSelected.IOpenNewAtsTaskEditorSelectedHandler,
RefreshAction.IRefreshActionHandler {
    private final WorldXViewer worldXViewer;
    protected IWorldEditor iWorldEditor;
    private boolean showRemoveMenuItems;

    public WorldComposite(IWorldEditor worldEditor, Composite parent, int style) {
        this(worldEditor, null, parent, style, true);
    }

    public WorldComposite(IWorldEditor worldEditor, IXViewerFactory xViewerFactory, Composite parent, int style, boolean createDragAndDrop) {
        super(parent, style);
        this.iWorldEditor = worldEditor;
        this.setLayout((Layout)new GridLayout(1, true));
        this.setLayoutData(new GridData(1808));
        if (DbConnectionExceptionComposite.dbConnectionIsOk((Composite)this)) {
            this.worldXViewer = this.createXViewer(xViewerFactory, this);
            this.worldXViewer.getTree().setLayoutData((Object)new GridData(1808));
            this.worldXViewer.setContentProvider((IContentProvider)new WorldContentProvider(this.worldXViewer));
            this.worldXViewer.setLabelProvider((IBaseLabelProvider)new WorldLabelProvider(this.worldXViewer));
            this.setupDragAndDropSupport(createDragAndDrop);
            WorldXViewerEventManager.add(this);
        } else {
            this.worldXViewer = null;
        }
    }

    protected void setupDragAndDropSupport(boolean createDragAndDrop) {
        if (createDragAndDrop) {
            new WorldViewDragAndDrop(this, "org.eclipse.osee.ats.ide.world.WorldEditor");
        }
    }

    protected WorldXViewer createXViewer(IXViewerFactory xViewerFactory, Composite mainComp) {
        return new WorldXViewer(mainComp, 67586, (IXViewerFactory)(xViewerFactory != null ? xViewerFactory : new WorldXViewerFactory(this)), null);
    }

    public static double getManHoursPerDayPreference(Collection<Artifact> worldArts) {
        if (worldArts.size() > 0) {
            Artifact artifact = worldArts.iterator().next();
            if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                artifact = AtsApiService.get().getQueryServiceIde().getArtifact(AtsApiService.get().getWorkItemService().getFirstTeam((Object)artifact));
            }
            return ((AbstractWorkflowArtifact)artifact).getManHrsPerDayPreference();
        }
        return 8.0;
    }

    public void setCustomizeData(CustomizeData customizeData) {
        this.worldXViewer.getCustomizeMgr().loadCustomization(customizeData);
    }

    public Control getControl() {
        return this.worldXViewer.getControl();
    }

    public void load(String name, Collection<? extends Artifact> arts, XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        this.load(name, arts, (CustomizeData)null, tableLoadOptions);
    }

    public void load(String name, Collection<? extends Artifact> arts, CustomizeData customizeData, XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        this.load(name, arts, customizeData, (Artifact)null, tableLoadOptions);
    }

    public void load(final String name, final Collection<? extends Artifact> arts, final CustomizeData customizeData, final Artifact expandToArtifact, final XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        Set loadOptions = Collections.asHashSet((Object[])tableLoadOptions);
        boolean forcePend = loadOptions.contains(XNavigateComposite.TableLoadOption.ForcePend);
        final Artifact fExpandToArtifact = expandToArtifact;
        if (!forcePend && Displays.isDisplayThread()) {
            Jobs.startJob((Job)new Job("World Composite - Load"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        WorldComposite.this.load(name, (Collection<? extends Artifact>)arts, customizeData, fExpandToArtifact, tableLoadOptions);
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                    return Status.OK_STATUS;
                }
            }, (boolean)true);
            return;
        }
        final LinkedList<Artifact> worldArts = new LinkedList<Artifact>();
        final LinkedList<Artifact> otherArts = new LinkedList<Artifact>();
        for (Artifact artifact : arts) {
            if (AtsObjects.isAtsWorkItemOrAction((Object)artifact)) {
                worldArts.add(artifact);
                continue;
            }
            otherArts.add(artifact);
        }
        try {
            AtsBulkLoad.bulkLoadArtifacts(worldArts);
        }
        catch (OseeCoreException oseeCoreException) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)oseeCoreException);
        }
        Displays.pendInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Widgets.isAccessible((Widget)WorldComposite.this.worldXViewer.getTree())) {
                    if (customizeData != null && !WorldComposite.this.worldXViewer.getCustomizeMgr().generateCustDataFromTable().equals((Object)customizeData)) {
                        WorldComposite.this.setCustomizeData(customizeData);
                    }
                    if (arts.isEmpty()) {
                        WorldComposite.this.setTableTitle("No Results Found - " + name, true);
                    } else {
                        WorldComposite.this.setTableTitle(name, false);
                    }
                    WorldComposite.this.worldXViewer.setInputXViewer(worldArts);
                    if (worldArts.size() == 0) {
                        WorldComposite.this.worldXViewer.setLoading(false);
                    }
                    WorldComposite.this.worldXViewer.updateStatusLabel();
                    if (otherArts.size() > 0 && MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Open in Artifact Editor?", (String)(String.valueOf(otherArts.size()) + " Non-WorldView Artifacts were returned from request.\n\nOpen in Artifact Editor?"))) {
                        RendererManager.openInJob((Collection)otherArts, (PresentationType)PresentationType.GENERALIZED_EDIT);
                    }
                    WorldComposite.this.worldXViewer.getTree().setFocus();
                }
            }
        });
        if (expandToArtifact != null) {
            Displays.pendInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (Widgets.isAccessible((Widget)WorldComposite.this.worldXViewer.getTree())) {
                        StructuredSelection newSelection = new StructuredSelection(Arrays.asList(expandToArtifact));
                        WorldComposite.this.worldXViewer.expandToLevel(expandToArtifact, 1);
                        WorldComposite.this.worldXViewer.setSelection((ISelection)newSelection);
                    }
                }
            });
        }
        this.iWorldEditor.reflow();
    }

    public void setTableTitle(final String title, final boolean warning) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String useTitle = Strings.truncate((String)title, (int)80);
                WorldComposite.this.iWorldEditor.setTableTitle(useTitle, warning);
            }
        });
    }

    public List<Artifact> getLoadedArtifacts() {
        return this.getXViewer().getLoadedArtifacts();
    }

    public void disposeComposite() {
        if (this.worldXViewer != null && !this.worldXViewer.getTree().isDisposed()) {
            this.worldXViewer.dispose();
        }
        WorldXViewerEventManager.remove(this);
    }

    public WorldXViewer getXViewer() {
        return this.worldXViewer;
    }

    public void refreshActionHandler() {
        try {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    WorldComposite.this.iWorldEditor.reSearch();
                }
            });
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    @Override
    public CustomizeData getCustomizeDataCopy() {
        CustomizeData generateCustDataFromTable = this.worldXViewer.getCustomizeMgr().generateCustDataFromTable();
        return generateCustDataFromTable;
    }

    @Override
    public IWorldEditorProvider getWorldEditorProviderCopy() {
        IWorldEditorProvider copyProvider = this.iWorldEditor.getWorldEditorProvider().copyProvider();
        return copyProvider;
    }

    @Override
    public List<Artifact> getSelectedArtifacts() {
        return this.worldXViewer.getSelectedArtifacts();
    }

    @Override
    public WorldXViewer getWorldXViewer() {
        return this.worldXViewer;
    }

    @Override
    public void relationsModifed(Collection<Artifact> relModifiedArts, Collection<Artifact> goalMemberReordered, Collection<Artifact> sprintMemberReordered) {
        XViewerColumn column;
        if (!goalMemberReordered.isEmpty() && (column = this.getXViewer().getCustomizeMgr().getCurrentTableColumn("ats.column.goalOrder")) != null && column.isShow()) {
            this.getXViewer().refreshColumnsWithPreCompute();
        }
        if (!sprintMemberReordered.isEmpty() && (column = this.getXViewer().getCustomizeMgr().getCurrentTableColumn("ats.column.sprintOrder")) != null && column.isShow()) {
            this.getXViewer().refreshColumnsWithPreCompute();
        }
    }

    public String toString() {
        return String.format("WorldComposite [%s]", this.iWorldEditor.getCurrentTitleLabel());
    }

    @Override
    public Set<Artifact> getSelectedWorkflowArtifacts() {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        for (Artifact art : this.getSelectedArtifacts()) {
            if (!(art instanceof AbstractWorkflowArtifact)) continue;
            artifacts.add(art);
        }
        return artifacts;
    }

    @Override
    public List<Artifact> getSelectedAtsArtifacts() {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Artifact art : this.getSelectedArtifacts()) {
            if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AtsArtifact})) continue;
            artifacts.add(art);
        }
        return artifacts;
    }

    @Override
    public List<TaskArtifact> getSelectedTaskArtifacts() {
        ArrayList<TaskArtifact> tasks = new ArrayList<TaskArtifact>();
        for (Artifact art : this.getSelectedArtifacts()) {
            if (!(art instanceof TaskArtifact)) continue;
            tasks.add((TaskArtifact)art);
        }
        return tasks;
    }

    @Override
    public ITaskEditorProvider getTaskEditorProviderCopy() {
        return (ITaskEditorProvider)this.getWorldEditorProviderCopy();
    }

    public String getEditorTitle() {
        try {
            return String.format("Table Report - %s", this.iWorldEditor.getCurrentTitleLabel());
        }
        catch (Exception exception) {
            return "Table Report - World Editor";
        }
    }

    public String getReportTitle() {
        return this.iWorldEditor.getCurrentTitleLabel();
    }

    public boolean isShowRemoveMenuItems() {
        return this.showRemoveMenuItems;
    }

    public void setShowRemoveMenuItems(boolean showRemoveMenuItems) {
        this.showRemoveMenuItems = showRemoveMenuItems;
        if (this.worldXViewer != null) {
            this.worldXViewer.setShowRemoveMenuItems(showRemoveMenuItems);
        }
    }

    @Override
    public Collection<TeamWorkFlowArtifact> getSelectedTeamWorkflowArtifacts() {
        HashSet<TeamWorkFlowArtifact> teamWfs = new HashSet<TeamWorkFlowArtifact>();
        for (Artifact art : this.getSelectedArtifacts()) {
            if (!(art instanceof TeamWorkFlowArtifact)) continue;
            teamWfs.add((TeamWorkFlowArtifact)art);
        }
        return teamWfs;
    }

    @Override
    public void handleColumnEvents(ArtifactEvent artifactEvent, WorldXViewer worldXViewer) {
        for (XViewerColumn col : worldXViewer.getColumns()) {
            if (!(col instanceof IAtsWorldArtifactEventColumn)) continue;
            ((IAtsWorldArtifactEventColumn)col).handleArtifactEvent(artifactEvent, worldXViewer);
        }
    }

    public static class FilterContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object arg0) {
            return ((ArrayList)arg0).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    public static class FilterLabelProvider
    implements ILabelProvider {
        public Image getImage(Object arg0) {
            return null;
        }

        public String getText(Object arg0) {
            try {
                return ((WorldSearchItem)arg0).getSelectedName(WorldSearchItem.SearchType.Search);
            }
            catch (OseeCoreException ex) {
                return ex.getLocalizedMessage();
            }
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }
    }
}

