/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task.internal;

import java.util.List;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.framework.core.util.Result;

public class TaskMover {
    private final IAtsTeamWorkflow newParent;
    private final List<? extends IAtsTask> tasks;

    public TaskMover(IAtsTeamWorkflow newParent, List<? extends IAtsTask> tasks) {
        this.newParent = newParent;
        this.tasks = tasks;
    }

    public Result moveTasks() {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Drop Add Tasks");
        for (IAtsTask iAtsTask : this.tasks) {
            TaskArtifact taskArt = (TaskArtifact)iAtsTask;
            taskArt.clearCaches();
            if (taskArt.getParentAWA() != null) {
                changes.unrelateAll((Object)taskArt, AtsRelationTypes.TeamWfToTask_TeamWorkflow);
            }
            changes.relate((Object)this.newParent, AtsRelationTypes.TeamWfToTask_Task, (Object)taskArt);
            taskArt.clearCaches();
        }
        if (!changes.isEmpty()) {
            changes.execute();
        }
        return Result.TrueResult;
    }
}

