/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.goal;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.CollectorArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;

public abstract class MembersManager<T extends CollectorArtifact> {
    public abstract RelationTypeSide getMembersRelationTypeSide();

    public abstract String getItemName();

    public abstract ArtifactTypeToken getArtifactType();

    public boolean isHasCollector(Artifact artifact) {
        return artifact.getRelatedArtifactsCount(this.getMembersRelationTypeSide().getOpposite()) > 0;
    }

    public T promptChangeMemberOrder(T memberArt, Artifact artifact) {
        return this.promptChangeMemberOrder(memberArt, Arrays.asList(artifact));
    }

    public void getCollectors(Artifact artifact, Set<Artifact> collectors, boolean recurse) {
        this.getCollectors(Arrays.asList(artifact), collectors, recurse);
    }

    public Collection<Artifact> getCollectors(Artifact artifact, boolean recurse) {
        HashSet<Artifact> collectors = new HashSet<Artifact>();
        this.getCollectors(artifact, collectors, recurse);
        return collectors;
    }

    public void getCollectors(Collection<Artifact> artifacts, Set<Artifact> goals, boolean recurse) {
        for (Artifact art : artifacts) {
            if (art.isOfType(new ArtifactTypeId[]{this.getArtifactType()})) {
                goals.add(art);
            }
            goals.addAll(art.getRelatedArtifacts(this.getMembersRelationTypeSide().getOpposite()));
            if (!recurse || !(art instanceof AbstractWorkflowArtifact) || ((AbstractWorkflowArtifact)art).getParentAWA() == null) continue;
            this.getCollectors(((AbstractWorkflowArtifact)art).getParentAWA(), goals, recurse);
        }
    }

    public T promptChangeMemberOrder(T memberArt, List<Artifact> artifacts) {
        Object obj = null;
        CollectorArtifact retVal = obj;
        StringBuilder currentOrder = new StringBuilder("Current Order: ");
        for (Artifact artifact : artifacts) {
            if (artifacts.size() == 1 && !this.isHasCollector(artifact) || memberArt == null) {
                AWorkbench.popup((String)String.format("No %s set for artifact [%s]", this.getItemName(), artifact));
                return (T)retVal;
            }
            String currIndexStr = this.getMemberOrder(memberArt, artifact);
            currentOrder.append(String.valueOf(currIndexStr) + ", ");
        }
        List members = memberArt.getMembers();
        EntryDialog ed = new EntryDialog(String.format("Change %S Order", this.getItemName()), String.format("%s: %s\n\n%s\n\nEnter New Order Number from 1..%d or %d for last.", this.getItemName(), memberArt, currentOrder.toString().replaceFirst(", $", ""), members.size(), members.size() + 1));
        ed.setNumberFormat(NumberFormat.getIntegerInstance());
        if (ed.open() == 0) {
            String newIndexStr = ed.getEntry();
            Integer enteredIndex = Integer.valueOf(newIndexStr);
            boolean insertLast = enteredIndex > members.size();
            Integer membersIndex = insertLast ? members.size() - 1 : enteredIndex - 1;
            if (membersIndex > members.size()) {
                AWorkbench.popup((String)String.format("New Order Number [%s] out of range 1..%d", newIndexStr, members.size()));
                return (T)retVal;
            }
            LinkedList<Artifact> reversed = new LinkedList<Artifact>(artifacts);
            Collections.reverse(reversed);
            for (Artifact artifact : reversed) {
                int currentIdx = members.indexOf(artifact);
                Artifact insertTarget = (Artifact)members.get(membersIndex);
                boolean insertAfter = membersIndex > currentIdx;
                memberArt.setRelationOrder(this.getMembersRelationTypeSide(), insertTarget, insertAfter, artifact);
            }
            memberArt.persist("Prompt-Change " + this.getItemName());
            return memberArt;
        }
        return (T)retVal;
    }

    public String getMemberOrder(Artifact artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{this.getArtifactType()})) {
            return "";
        }
        if (!this.isHasCollector(artifact)) {
            return "";
        }
        Collection<Artifact> collectors = this.getCollectors(artifact, false);
        ArrayList<Artifact> collectorsSorted = new ArrayList<Artifact>(collectors);
        Collections.sort(collectorsSorted);
        StringBuffer sb = new StringBuffer();
        for (Artifact member : collectorsSorted) {
            sb.append(String.format("%s-[%s] ", this.getMemberOrder((CollectorArtifact)member, artifact), member));
        }
        return sb.toString();
    }

    public abstract String getMemberOrder(T var1, Artifact var2);
}

