/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workdef.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.ide.editor.tab.workflow.util.WfeOutlinePage;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorOutlineProvider;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorProvider;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorTab;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.skynet.results.table.IResultsEditorTableTab;
import org.eclipse.osee.framework.ui.skynet.results.table.ResultsEditorTableTab;
import org.eclipse.osee.framework.ui.skynet.results.table.ResultsXViewerRow;
import org.eclipse.osee.framework.ui.skynet.results.table.xresults.IResultsEditorTableListener;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class WorkDefinitionViewer
extends XNavigateItemAction {
    public static final String TITLE = "Work Definition Viewer";
    private IAtsWorkDefinition workDef;
    private WfeOutlinePage outlinePage;

    public WorkDefinitionViewer(XNavItemCat category) {
        super(TITLE, (KeyedImage)PluginUiImage.ADMIN, new XNavItemCat[]{category});
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) throws Exception {
        ResultsEditor.open((IResultsEditorProvider)new IResultsEditorProvider(){
            private List<IResultsEditorTab> tabs;

            public String getEditorName() {
                return WorkDefinitionViewer.TITLE;
            }

            public List<IResultsEditorTab> getResultsEditorTabs() {
                if (this.tabs == null) {
                    this.tabs = new LinkedList<IResultsEditorTab>();
                    IResultsEditorTableTab workDefinitionTab = WorkDefinitionViewer.this.createWorkDefinitionTab();
                    workDefinitionTab.addListener(WorkDefinitionViewer.this.getListener());
                    workDefinitionTab.addOutlineProvider(WorkDefinitionViewer.this.getOutlineProvider());
                    this.tabs.add((IResultsEditorTab)workDefinitionTab);
                }
                return this.tabs;
            }
        });
    }

    private IResultsEditorOutlineProvider getOutlineProvider() {
        final WorkDefinitionViewer definitionViewer = this;
        return new IResultsEditorOutlineProvider(){

            public ContentOutlinePage getOutlinePage() {
                WorkDefinitionViewer.this.outlinePage = new WfeOutlinePage();
                WorkDefinitionViewer.this.outlinePage.setWorkDefViewer(definitionViewer);
                return WorkDefinitionViewer.this.outlinePage;
            }
        };
    }

    private IResultsEditorTableListener getListener() {
        final WorkDefinitionViewer definitionViewer = this;
        return new IResultsEditorTableListener(){

            public void handleSelectionListener(Collection<ResultsXViewerRow> selectedRows) {
                this.handleSelection(definitionViewer, selectedRows);
            }

            private void handleSelection(WorkDefinitionViewer definitionViewer2, Collection<ResultsXViewerRow> selectedRows) {
                if (!selectedRows.isEmpty()) {
                    IWorkbenchPage page = AWorkbench.getActivePage();
                    try {
                        page.showView("org.eclipse.ui.views.ContentOutline", null, 1);
                    }
                    catch (PartInitException ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                    WorkDefinitionViewer.this.workDef = (IAtsWorkDefinition)selectedRows.iterator().next().getData();
                    WorkDefinitionViewer.this.outlinePage.setInput((Object)definitionViewer2);
                }
            }

            public void handleDoubleClick(ArrayList<ResultsXViewerRow> selectedRows) {
                this.handleSelection(definitionViewer, selectedRows);
            }
        };
    }

    private IResultsEditorTableTab createWorkDefinitionTab() {
        List<XViewerColumn> artColumns = Arrays.asList(new XViewerColumn("Name", "Name", 300, XViewerAlign.Left, true, SortDataType.String, false, ""), new XViewerColumn("ID", "ID", 200, XViewerAlign.Left, true, SortDataType.String, false, ""));
        ArrayList<ResultsXViewerRow> workDefRows = new ArrayList<ResultsXViewerRow>();
        try {
            ArrayList workDefs = new ArrayList();
            workDefs.addAll(AtsApiService.get().getWorkDefinitionService().getAllWorkDefinitions());
            Collections.sort(workDefs, new Comparator<IAtsWorkDefinition>(){

                @Override
                public int compare(IAtsWorkDefinition o1, IAtsWorkDefinition o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (IAtsWorkDefinition workDef : workDefs) {
                workDefRows.add(new ResultsXViewerRow(new String[]{workDef.getName(), workDef.getIdString()}, (Object)workDef));
            }
        }
        catch (OseeCoreException oseeCoreException) {}
        return new ResultsEditorTableTab("Work Definitions", artColumns, workDefRows);
    }

    public IAtsWorkDefinition getWorkDef() {
        return this.workDef;
    }
}

