/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.walker;

import java.util.logging.Level;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.walker.IActionWalkerItem;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.graphics.Image;

public class GoalMemberWrapper
implements IActionWalkerItem {
    private final GoalArtifact goal;

    public GoalMemberWrapper(GoalArtifact goal) {
        this.goal = goal;
    }

    public String toString() {
        try {
            return String.format(String.valueOf(this.goal.getMembers().size()) + " Members", new Object[0]);
        }
        catch (OseeCoreException ex) {
            return "Exception: " + ex.getLocalizedMessage();
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.goal == null ? 0 : this.goal.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GoalMemberWrapper other = (GoalMemberWrapper)obj;
        return !(this.goal == null ? other.goal != null : !this.goal.equals(other.goal));
    }

    @Override
    public Image getImage() {
        return ImageManager.getImage((OseeImage)AtsImage.GOAL);
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public void handleDoubleClick() {
        try {
            AtsEditors.openInAtsWorldEditor(String.format("Goal [%s] Members", this.goal.getName()), this.goal.getMembers());
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }
}

