/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.xviewer.column;

import org.eclipse.nebula.widgets.xviewer.XViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.util.XViewerException;
import org.eclipse.osee.ats.api.review.IAtsPeerReviewRoleManager;
import org.eclipse.osee.ats.api.review.UserRole;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.ide.workflow.review.AbstractReviewArtifact;
import org.eclipse.osee.ats.ide.workflow.review.PeerToPeerReviewArtifact;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class XViewerReviewRoleColumn
extends XViewerValueColumn {
    private final AtsUser user;

    public XViewerReviewRoleColumn copy() {
        return new XViewerReviewRoleColumn(this.getUser(), this.getId(), this.getName(), this.getWidth(), this.getAlign(), this.isShow(), this.getSortDataType(), this.isMultiColumnEditable(), this.getDescription());
    }

    public XViewerReviewRoleColumn(AtsUser user) {
        super("ats.column.role", "Role", 75, XViewerAlign.Left, true, SortDataType.String, false, null);
        this.user = user;
    }

    public XViewerReviewRoleColumn(AtsUser user, String id, String name, int width, XViewerAlign align, boolean show, SortDataType sortDataType, boolean multiColumnEditable, String description) {
        super(id, name, width, align, show, sortDataType, multiColumnEditable, description);
        this.user = user;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) throws XViewerException {
        try {
            if (element instanceof AbstractReviewArtifact) {
                return XViewerReviewRoleColumn.getRolesStr((AbstractReviewArtifact)((Object)element), this.user);
            }
            return "";
        }
        catch (OseeCoreException ex) {
            throw new XViewerException((Throwable)ex);
        }
    }

    private static String getRolesStr(AbstractReviewArtifact reviewArt, AtsUser user) {
        StringBuilder builder = new StringBuilder();
        IAtsPeerReviewRoleManager roleMgr = ((PeerToPeerReviewArtifact)reviewArt).getRoleManager();
        for (UserRole role : roleMgr.getUserRoles()) {
            if (!role.getUserId().equals(user.getUserId())) continue;
            builder.append(role.getRole().getName());
            builder.append(", ");
        }
        return builder.toString().replaceFirst(", $", "");
    }

    public AtsUser getUser() {
        return this.user;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        XViewerReviewRoleColumn other = (XViewerReviewRoleColumn)((Object)obj);
        return !(this.user == null ? other.user != null : !this.user.equals((Object)other.user));
    }
}

