/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.dialog;

import java.util.ArrayList;
import java.util.logging.Level;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.VersionLockedType;
import org.eclipse.osee.ats.api.version.VersionReleaseType;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsObjectLabelProvider;
import org.eclipse.osee.ats.ide.util.widgets.dialog.AtsObjectNameSorter;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.widgets.XComboViewer;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TeamVersionListDialog
extends SelectionDialog {
    XComboViewer teamCombo = new XComboViewer("Team", 8);
    XComboViewer versionCombo = new XComboViewer("Version", 8);
    IAtsVersion selectedVersion = null;
    IAtsTeamDefinition selectedTeamDef = null;
    private final Active active;
    private final IAtsTeamDefinition teamDef;

    public TeamVersionListDialog(Active active) {
        super(Displays.getActiveShell());
        this.active = active;
        this.teamDef = null;
        this.setTitle("Select Version");
        this.setMessage("Select Version");
    }

    protected Control createDialogArea(Composite container) {
        ArrayList<Object> objs = new ArrayList<Object>();
        try {
            for (IAtsTeamDefinition art : AtsApiService.get().getTeamDefinitionService().getTeamReleaseableDefinitions(this.active)) {
                objs.add(art);
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        Composite comp = new Composite(container, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        if (this.teamDef == null) {
            this.teamCombo.setInput(objs);
            this.teamCombo.setLabelProvider((ILabelProvider)new AtsObjectLabelProvider());
            this.teamCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.teamCombo.setComparator((ViewerComparator)new AtsObjectNameSorter());
            this.teamCombo.setGrabHorizontal(true);
            this.teamCombo.createWidgets(comp, 2);
            this.teamCombo.getCombo().setVisibleItemCount(20);
            this.teamCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    ArrayList<IAtsVersion> objs = new ArrayList<IAtsVersion>();
                    try {
                        TeamVersionListDialog.this.selectedTeamDef = (IAtsTeamDefinition)TeamVersionListDialog.this.teamCombo.getSelected();
                        for (IAtsVersion pda : AtsApiService.get().getVersionService().getVersions(TeamVersionListDialog.this.selectedTeamDef, VersionReleaseType.Both, VersionLockedType.Both)) {
                            objs.add(pda);
                        }
                        TeamVersionListDialog.this.versionCombo.setInput(objs);
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
            });
        } else {
            this.selectedTeamDef = this.teamDef;
        }
        this.versionCombo.setLabelProvider((ILabelProvider)new AtsObjectLabelProvider());
        this.versionCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.versionCombo.setComparator((ViewerComparator)new AtsObjectNameSorter());
        this.versionCombo.setGrabHorizontal(true);
        this.versionCombo.createWidgets(comp, 2);
        this.versionCombo.getCombo().setVisibleItemCount(20);
        this.versionCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TeamVersionListDialog.this.selectedVersion = (IAtsVersion)TeamVersionListDialog.this.versionCombo.getSelected();
            }
        });
        if (this.teamDef != null) {
            objs = new ArrayList();
            try {
                for (IAtsVersion pda : AtsApiService.get().getVersionService().getVersions(this.teamDef, VersionReleaseType.Both, VersionLockedType.Both)) {
                    objs.add(pda);
                }
                this.versionCombo.setInput(objs);
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return container;
    }

    public IAtsVersion getSelectedVersion() {
        return this.selectedVersion;
    }

    public IAtsTeamDefinition getSelectedTeamDef() {
        return this.selectedTeamDef;
    }
}

