/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.defect;

import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.workflow.review.PeerToPeerReviewArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XLabelValue;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.IOseeTreeReportProvider;

public class XDefectViewer
extends XLabelValue
implements ArtifactWidget,
IOseeTreeReportProvider {
    private PeerToPeerReviewArtifact reviewArt;
    public static final String normalColor = "#EEEEEE";

    public XDefectViewer() {
        super("Defects", "");
    }

    public Artifact getArtifact() {
        return this.reviewArt.getArtifact();
    }

    public void saveToArtifact() {
    }

    public void revert() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void setArtifact(Artifact artifact) {
        this.reviewArt = (PeerToPeerReviewArtifact)artifact;
        this.refreshLabel();
    }

    public void refresh() {
        super.refresh();
        this.refreshLabel();
    }

    private void refreshLabel() {
        this.setValueText(String.format("%d Found. See Defects tab for details", this.reviewArt.getAttributeCount((AttributeTypeId)AtsAttributeTypes.ReviewDefect)));
    }

    public PeerToPeerReviewArtifact getReviewArt() {
        return this.reviewArt;
    }

    public String getEditorTitle() {
        try {
            return String.format("Table Report - Defects for [%s]", new Object[]{this.getReviewArt()});
        }
        catch (Exception exception) {
            return "Table Report - Defects";
        }
    }

    public String getReportTitle() {
        return this.getEditorTitle();
    }
}

