/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XWorkingBranchButtonAbstract;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.UpdateBranchData;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.update.ConflictResolverOperation;
import org.eclipse.osee.framework.skynet.core.conflict.ConflictManagerExternal;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.ITopicEventFilter;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.util.RebaselineInProgressHandler;
import org.eclipse.osee.framework.ui.skynet.widgets.xmerge.MergeView;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class XWorkingBranchUpdate
extends XWorkingBranchButtonAbstract {
    @Override
    protected void initButton(Button button) {
        button.setToolTipText("Update Working Branch From Targeted Version or Team Configured Branch");
        button.setImage(ImageManager.getImage((KeyedImage)FrameworkImage.BRANCH_SYNCH));
        button.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    BranchToken branchToUpdate = XWorkingBranchUpdate.this.getWorkingBranch();
                    if (branchToUpdate != null) {
                        Artifact associatedArtifact = BranchManager.getAssociatedArtifact((BranchId)branchToUpdate);
                        IAtsWorkItem workItem = AtsApiService.get().getWorkItemService().getWorkItem((ArtifactToken)associatedArtifact);
                        if (workItem == null || !workItem.isTeamWorkflow()) {
                            AWorkbench.popup((String)"Working Branch must have associated Team Workflow");
                            return;
                        }
                        IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)workItem;
                        BranchId targetedBranch = AtsApiService.get().getBranchService().getConfiguredBranchForWorkflow(teamWf);
                        if (BranchManager.isUpdatable((BranchId)branchToUpdate)) {
                            if (BranchManager.getState((BranchId)branchToUpdate).isRebaselineInProgress()) {
                                RebaselineInProgressHandler.handleRebaselineInProgress((BranchId)branchToUpdate);
                            } else {
                                boolean isUserSure = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Update Branch", (String)String.format("Are you sure you want to update [%s]\n branch from Targeted Version or Team Configured branch [%s]?", branchToUpdate.getName(), BranchManager.getBranchToken((BranchId)targetedBranch).getName()));
                                if (isUserSure) {
                                    UpdateBranchData branchData = BranchManager.updateBranch((BranchToken)branchToUpdate, (ConflictResolverOperation)new UserConflictResolver());
                                    if (branchData.getResults().isErrors()) {
                                        XResultDataUI.report((XResultData)branchData.getResults(), (String)"Update Branch Failed");
                                    } else if (branchData.isNeedsMerge()) {
                                        XResultDataUI.report((XResultData)branchData.getResults(), (String)"Branch needs to be merged.");
                                    }
                                }
                            }
                        } else {
                            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Can't Update Branch", (String)String.format("Couldn't update [%s] because it currently has merge branches from commits.  To perform an update please delete all the merge branches for this branch.", branchToUpdate.getName()));
                        }
                    }
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        });
    }

    @Override
    protected void refreshEnablement(Button button) {
        button.setEnabled(!this.disableAll && this.isWorkingBranchInWork() && !this.isCommittedBranchExists() && !this.isWorkingBranchCommitWithMergeInProgress() && this.isWidgetAllowedInCurrentState());
    }

    @Override
    protected boolean isWidgetAllowedInCurrentState() {
        return this.isWidgetInState(XWorkingBranchUpdate.class.getSimpleName());
    }

    public List<? extends ITopicEventFilter> getTopicEventFilters() {
        return null;
    }

    private static final class UserConflictResolver
    extends ConflictResolverOperation {
        public UserConflictResolver() {
            super("Launch Merge Manager", "org.eclipse.osee.ats.ide");
        }

        protected void doWork(IProgressMonitor monitor) throws Exception {
            ConflictManagerExternal conflictManager = this.getConflictManager();
            Job job = this.createMergeViewJob((BranchId)conflictManager.getSourceBranch(), (BranchId)conflictManager.getDestinationBranch());
            Jobs.startJob((Job)job);
        }

        private Job createMergeViewJob(final BranchId sourceBranch, final BranchId destinationBranch) {
            UIJob job = new UIJob("Launch Merge Manager"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IStatus status = Status.OK_STATUS;
                    try {
                        IWorkbenchPage page = AWorkbench.getActivePage();
                        IViewPart viewPart = page.showView("org.eclipse.osee.framework.ui.skynet.widgets.xmerge.MergeView", String.valueOf(sourceBranch.getId() * 100000L + destinationBranch.getId()), 1);
                        if (viewPart instanceof MergeView) {
                            MergeView mergeView = (MergeView)viewPart;
                            mergeView.explore(sourceBranch, destinationBranch, null, null, true);
                        }
                    }
                    catch (PartInitException ex) {
                        status = new Status(4, "org.eclipse.osee.ats.ide", "Error launching merge view", (Throwable)ex);
                    }
                    return status;
                }
            };
            return job;
        }
    }
}

