/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.List;
import org.eclipse.osee.ats.ide.util.widgets.XWorkingBranchWidgetAbstract;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.ITopicEventFilter;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class XWorkingBranchLabel
extends XWorkingBranchWidgetAbstract {
    public static String NAME = "Working Branch";

    public XWorkingBranchLabel() {
        OseeEventManager.addListener((IEventListener)this);
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        if (horizontalSpan < 2) {
            horizontalSpan = 2;
        }
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        mainComp.setLayoutData((Object)new GridData(768));
        if (this.toolkit != null) {
            this.toolkit.adapt(mainComp);
        }
        this.setLabel(NAME);
        this.labelWidget = new Label(mainComp, 0);
        this.labelWidget.setLayoutData((Object)new GridData(768));
        this.refreshWorkingBranchWidget();
    }

    @Override
    protected void refreshWorkingBranchWidget() {
        if (this.getTeamArt() == null || this.labelWidget == null || this.labelWidget.isDisposed()) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Displays.ensureInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (XWorkingBranchLabel.this.labelWidget != null && Widgets.isAccessible((Widget)XWorkingBranchLabel.this.labelWidget) && !XWorkingBranchLabel.this.getLabel().equals("")) {
                            BranchToken workBranch = XWorkingBranchLabel.this.getWorkingBranch();
                            String labelStr = String.valueOf(XWorkingBranchLabel.this.getLabel()) + ": " + XWorkingBranchLabel.this.getStatus().getDisplayName() + (workBranch != null && workBranch.isValid() ? " - " + workBranch.getShortName() : "");
                            XWorkingBranchLabel.this.labelWidget.setText(labelStr);
                            if (XWorkingBranchLabel.this.getToolTip() != null) {
                                XWorkingBranchLabel.this.labelWidget.setToolTipText(XWorkingBranchLabel.this.getToolTip());
                            }
                            XWorkingBranchLabel.this.labelWidget.getParent().redraw();
                            if (XWorkingBranchLabel.this.getManagedForm() != null) {
                                XWorkingBranchLabel.this.getManagedForm().reflow(true);
                            }
                        }
                    }
                });
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    @Override
    public Control getControl() {
        return this.labelWidget;
    }

    public List<? extends ITopicEventFilter> getTopicEventFilters() {
        return null;
    }
}

