/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util;

import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osee.ats.ide.AtsOpenOption;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.framework.core.client.server.HttpResponse;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.jdk.core.type.MutableBoolean;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.httpRequests.BaseArtifactLoopbackCmd;
import org.eclipse.osee.framework.ui.swt.Displays;

public class OpenInAtsLoopbackCmd
extends BaseArtifactLoopbackCmd {
    public boolean isApplicable(String cmd) {
        return cmd != null && cmd.equalsIgnoreCase("open.ats");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(final Artifact artifact, Map<String, String> parameters, final HttpResponse httpResponse) {
        if (artifact == null) {
            httpResponse.outputStandardError(400, "Unable to open null artifact");
            return;
        }
        try {
            boolean hasPermissionToRead = false;
            try {
                hasPermissionToRead = AtsApiService.get().getAccessControlService().hasArtifactPermission((ArtifactToken)artifact, PermissionEnum.READ, null).isSuccess();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
            if (!hasPermissionToRead) {
                httpResponse.outputStandardError(401, String.format("Access denied - User does not have read access to [%s]", artifact));
                return;
            }
            final MutableBoolean isDone = new MutableBoolean(false);
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            AtsEditors.openATSAction((ArtifactToken)artifact, AtsOpenOption.OpenOneOrPopupSelect);
                            String html = AHTML.simplePage((String)("Action [" + artifact.getName() + "]has been opened in OSEE ATS<br><br>" + "<form><input type=button onClick='window.opener=self;window.close()' value='Close'></form>"));
                            httpResponse.getPrintStream().println(html);
                        }
                        catch (Exception ex) {
                            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                            httpResponse.outputStandardError(500, String.format("Unable to open: [%s]", artifact.getName()), (Throwable)ex);
                            isDone.setValue(true);
                        }
                    }
                    finally {
                        isDone.setValue(true);
                    }
                }
            });
            int count = 1;
            while (!isDone.getValue()) {
                if (count >= 30) {
                    return;
                }
                try {
                    Thread.sleep(350L);
                }
                catch (InterruptedException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
                ++count;
            }
            return;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            httpResponse.outputStandardError(500, String.format("Unable to open: [%s]", artifact.getName()), (Throwable)ex);
            return;
        }
    }
}

