/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.ide.search.widget.AbstractSearchWidget;
import org.eclipse.osee.ats.ide.world.WorldEditorParameterSearchItem;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.skynet.ToStringViewerSorter;
import org.eclipse.osee.framework.ui.skynet.widgets.XComboViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public abstract class AbstractXComboViewerSearchWidget<ObjectType>
extends AbstractSearchWidget<XComboViewer, Object> {
    public static final String CLEAR = "--clear--";
    boolean listenerAdded = false;

    public AbstractXComboViewerSearchWidget(String name, WorldEditorParameterSearchItem searchItem) {
        super(name, "XComboViewer", searchItem);
    }

    public ObjectType get() {
        ObjectType obj;
        XComboViewer combo = this.getWidget();
        if (combo != null) {
            return (ObjectType)combo.getSelected();
        }
        ObjectType object = obj = null;
        return object;
    }

    @Override
    public XComboViewer getWidget() {
        return (XComboViewer)super.getWidget();
    }

    public abstract void set(AtsSearchData var1);

    public abstract Collection<ObjectType> getInput();

    public void setup(XWidget widget) {
        if (widget != null) {
            final XComboViewer combo = (XComboViewer)widget;
            ArrayList<String> input = new ArrayList<String>();
            input.addAll(Collections.castAll(this.getInput()));
            if (!input.contains(CLEAR)) {
                input.add(CLEAR);
            }
            combo.setInput(input);
            combo.setComparator((ViewerComparator)new ToStringViewerSorter(true));
            combo.getCombo().setText(this.getInitialText());
            if (!this.listenerAdded) {
                this.listenerAdded = true;
                combo.getLabelWidget().addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent e) {
                        super.mouseDown(e);
                        if (e.button == 3) {
                            AbstractXComboViewerSearchWidget.this.handleRightClickLabel();
                        }
                    }
                });
                combo.getLabelWidget().setToolTipText("Right-click to clear");
                combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        super.widgetSelected(e);
                        if (combo.getSelected().toString().equals(AbstractXComboViewerSearchWidget.CLEAR)) {
                            AbstractXComboViewerSearchWidget.this.handleRightClickLabel();
                        }
                    }
                });
            }
        }
    }

    public void handleRightClickLabel() {
        this.clear();
    }

    protected void clear() {
        if (this.getWidget() != null) {
            this.setup((XWidget)this.getWidget());
            XComboViewer combo = this.getWidget();
            combo.setSelected(Arrays.asList(""));
            if (Strings.isValid((String)this.getInitialText())) {
                combo.getCombo().setText(this.getInitialText());
            }
        }
    }

    public String getInitialText() {
        return "";
    }
}

