/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.members;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.core.model.FilterData;
import org.eclipse.nebula.widgets.xviewer.core.model.SortingData;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.ide.editor.tab.members.IMemberProvider;
import org.eclipse.osee.ats.ide.editor.tab.members.WfeMembersTab;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.world.WorldComposite;
import org.eclipse.osee.ats.ide.world.WorldViewDragAndDrop;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactData;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.artifact.ArtifactTransfer;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Shell;

public class WfeMembersTabDragAndDrop
extends WorldViewDragAndDrop {
    private boolean isFeedbackAfter = false;
    private final WorldComposite worldComposite;
    private final IMemberProvider provider;

    public WfeMembersTabDragAndDrop(WorldComposite worldComposite, IMemberProvider provider, String viewId) {
        super(worldComposite, viewId);
        this.worldComposite = worldComposite;
        this.provider = provider;
    }

    private Artifact getSelectedArtifact(DropTargetEvent event) {
        if (event.item != null && event.item.getData() instanceof Artifact) {
            return AtsApiService.get().getQueryServiceIde().getArtifact((ArtifactId)AtsApiService.get().getQueryServiceIde().getArtifact(event.item.getData()));
        }
        return null;
    }

    private CustomizeData getCustomizeData() {
        CustomizeData customizeData = this.worldComposite.getCustomizeDataCopy();
        Conditions.checkNotNull((Object)customizeData, (String)"Customized Data");
        return customizeData;
    }

    private FilterData getFilterData() {
        FilterData filterData = this.getCustomizeData().getFilterData();
        Conditions.checkNotNull((Object)filterData, (String)"Filter Data");
        return filterData;
    }

    private SortingData getSortingData() {
        SortingData sortingData = this.getCustomizeData().getSortingData();
        Conditions.checkNotNull((Object)sortingData, (String)"Sort Data");
        return sortingData;
    }

    private String getFilterText() {
        String filterText = this.getFilterData().getFilterText();
        Conditions.checkNotNull((Object)filterText, (String)"Filter Text");
        return filterText;
    }

    private List<String> getSortingIds() {
        return this.getSortingData().getSortingIds();
    }

    private boolean isSortedByCollectorsOrder() {
        List<String> sortingIds = this.getSortingIds();
        return sortingIds.size() == 1 && sortingIds.contains(this.provider.getColumnName());
    }

    private boolean isFiltered() {
        String filterText = this.getFilterText();
        return Strings.isValid((String)filterText);
    }

    private boolean isDropValid() {
        return !this.isFiltered() && this.isSortedByCollectorsOrder();
    }

    public void operationChanged(DropTargetEvent event) {
        this.isFeedbackAfter = event.detail == 1;
    }

    @Override
    protected boolean isValidForArtifactDrop(DropTargetEvent event) {
        ArtifactData artData;
        boolean validForDrop = false;
        if (ArtifactTransfer.getInstance().isSupportedType(event.currentDataType) && (artData = ArtifactTransfer.getInstance().nativeToJava(event.currentDataType)) != null) {
            Artifact[] artifacts;
            Artifact[] artifactArray = artifacts = artData.getArtifacts();
            int n = artifacts.length;
            int n2 = 0;
            while (n2 < n) {
                Artifact art = artifactArray[n2];
                if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact}) || art.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.UniversalGroup})) {
                    validForDrop = true;
                    break;
                }
                ++n2;
            }
        }
        return validForDrop;
    }

    @Override
    public void performDragOver(DropTargetEvent event) {
        if (this.isValidForArtifactDrop(event)) {
            event.detail = 1;
            Artifact selectedArtifact = this.getSelectedArtifact(event);
            if (selectedArtifact != null) {
                event.feedback = this.isFeedbackAfter ? 12 : 10;
            }
        } else {
            event.feedback = 2003;
        }
    }

    @Override
    public void performDrop(DropTargetEvent event) {
        ArtifactData artData = ArtifactTransfer.getInstance().nativeToJava(event.currentDataType);
        List<Artifact> droppedArtifacts = Arrays.asList(artData.getArtifacts());
        Collections.reverse(droppedArtifacts);
        Artifact dropTarget = this.getSelectedArtifact(event);
        try {
            boolean dropValid = this.isDropValid();
            if (dropValid && ArtifactTransfer.getInstance().isSupportedType(event.currentDataType)) {
                Collections.reverse(droppedArtifacts);
                List<Artifact> members = this.provider.getMembers();
                Result result = this.provider.isAddValid(droppedArtifacts);
                if (result.isFalse()) {
                    if (MessageDialog.openQuestion((Shell)Displays.getActiveShell(), (String)"Drop Error", (String)result.getText())) {
                        for (Artifact dropped : droppedArtifacts) {
                            dropped.deleteRelations(this.provider.getMemberRelationTypeSide().getOpposite());
                        }
                    } else {
                        return;
                    }
                }
                for (Artifact dropped : droppedArtifacts) {
                    if (!dropped.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) continue;
                    if (!members.contains(dropped)) {
                        this.provider.addMember(dropped);
                    }
                    if (dropTarget == null) continue;
                    this.provider.getArtifact().setRelationOrder(this.provider.getMemberRelationTypeSide(), dropTarget, this.isFeedbackAfter, dropped);
                }
                this.provider.getArtifact().persist(WfeMembersTab.class.getSimpleName());
            } else if (!dropValid) {
                AWorkbench.popup((String)"Drag/Drop is disabled when table is filtered or sorted.\n\nSwitch to default table customization and try again.");
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)Lib.exceptionToString((Exception)((Object)ex)));
        }
    }
}

