/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config.wizard;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.ide.AtsOpenOption;
import org.eclipse.osee.ats.ide.config.AtsConfigOperation;
import org.eclipse.osee.ats.ide.config.wizard.AtsConfigWizardPage1;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.skynet.render.RendererManager;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.progress.UIJob;

public class AtsConfigWizard
extends Wizard
implements INewWizard {
    private AtsConfigWizardPage1 page1;

    public void addPages() {
        this.addPage((IWizardPage)this.page1);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.page1 = new AtsConfigWizardPage1();
    }

    public boolean performFinish() {
        try {
            String teamDefName = this.page1.getTeamDefName();
            List<String> aias = this.page1.getActionableItems();
            List<String> versionNames = this.page1.getVersions();
            String workDefName = this.page1.getWorkDefinitionName();
            OpenAtsConfigEditors display = new OpenAtsConfigEditors();
            AtsConfigOperation operation = new AtsConfigOperation(workDefName, teamDefName, versionNames, aias);
            Operations.executeAsJob((IOperation)operation, (boolean)true);
            display.openAtsConfigurationEditors(operation.getTeamDefinition(), operation.getActionableItems(), operation.getWorkDefinition());
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return false;
        }
        return true;
    }

    private static final class OpenAtsConfigEditors
    implements AtsConfigOperation.Display {
        private OpenAtsConfigEditors() {
        }

        @Override
        public void openAtsConfigurationEditors(final IAtsTeamDefinition teamDef, final Collection<IAtsActionableItem> aias, final IAtsWorkDefinition workDefinition) {
            UIJob job = new UIJob("Open Ats Configuration Editors"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        AtsEditors.openATSAction(AtsApiService.get().getQueryService().getArtifact((IAtsObject)teamDef), AtsOpenOption.OpenAll);
                        for (IAtsActionableItem aia : aias) {
                            AtsEditors.openATSAction(AtsApiService.get().getQueryService().getArtifact((IAtsObject)aia), AtsOpenOption.OpenAll);
                        }
                        RendererManager.open((Artifact)ArtifactQuery.getArtifactFromTypeAndName((ArtifactTypeId)AtsArtifactTypes.WorkDefinition, (String)workDefinition.getName(), (BranchId)AtsApiService.get().getAtsBranch()), (PresentationType)PresentationType.SPECIALIZED_EDIT, (IProgressMonitor)monitor);
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                    return Status.OK_STATUS;
                }
            };
            Jobs.startJob((Job)job, (boolean)true);
        }
    }
}

