/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class RelatedArtifactLastModifiedByColumn
extends XViewerAtsColumn
implements IXViewerValueColumn {
    public static RelatedArtifactLastModifiedByColumn instance = new RelatedArtifactLastModifiedByColumn();

    public static RelatedArtifactLastModifiedByColumn getInstance() {
        return instance;
    }

    private RelatedArtifactLastModifiedByColumn() {
        super("ats.column.RelatedArtifactLastModifiedByColumn", "Related Artifact Last Modified By", 75, XViewerAlign.Left, false, SortDataType.String, false, "Shows the last person to modify the related artifact");
    }

    public RelatedArtifactLastModifiedByColumn copy() {
        RelatedArtifactLastModifiedByColumn newXCol = new RelatedArtifactLastModifiedByColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            Artifact refArt;
            ArtifactId refArtId;
            if (element instanceof Artifact && (refArtId = (ArtifactId)AtsApiService.get().getQueryServiceIde().getArtifact(element).getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.TaskToChangedArtifactReference, (Object)ArtifactId.SENTINEL)).isValid() && (refArt = AtsApiService.get().getQueryServiceIde().getArtifact(refArtId)) != null) {
                return refArt.getLastModifiedBy().getName();
            }
        }
        catch (OseeCoreException ex) {
            return LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
        return "";
    }
}

