/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Date;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class LastStatusedColumn
extends XViewerAtsColumn
implements IXViewerValueColumn {
    public static LastStatusedColumn instance = new LastStatusedColumn();

    public static LastStatusedColumn getInstance() {
        return instance;
    }

    private LastStatusedColumn() {
        super("ats.column.lastStatused", "Last Statused", 40, XViewerAlign.Center, false, SortDataType.Date, false, "Retrieves timestamp of status (percent completed or hours spent).");
    }

    public LastStatusedColumn copy() {
        LastStatusedColumn newXCol = new LastStatusedColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            if (element instanceof AbstractWorkflowArtifact) {
                return DateUtil.getMMDDYYHHMM((Date)((AbstractWorkflowArtifact)((Object)element)).getLog().getLastStatusDate());
            }
            if (Artifacts.isOfType((Object)element, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
                return "(see children)";
            }
        }
        catch (OseeCoreException ex) {
            LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
        return "";
    }
}

