/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.branch.internal;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IBranchEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEvent;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEventType;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;

public class AtsBranchManagerUpdateListener
implements IBranchEventListener {
    private static final List<BranchEventType> EVENT_TYPES = Arrays.asList(BranchEventType.Added, BranchEventType.CommitFailed, BranchEventType.Committed, BranchEventType.Committing);

    public List<? extends IEventFilter> getEventFilters() {
        return null;
    }

    public void handleBranchEvent(Sender sender, BranchEvent branchEvent) {
        if (!EVENT_TYPES.contains(branchEvent.getEventType())) {
            return;
        }
        try {
            ArtifactId associatedArtifact = BranchManager.getAssociatedArtifactId((BranchId)branchEvent.getSourceBranch());
            Artifact assocArtInCache = ArtifactCache.getActive((ArtifactId)associatedArtifact, (BranchId)CoreBranches.COMMON);
            if (assocArtInCache != null && assocArtInCache instanceof TeamWorkFlowArtifact) {
                TeamWorkFlowArtifact teamArt = (TeamWorkFlowArtifact)assocArtInCache;
                if (branchEvent.getEventType() == BranchEventType.Added) {
                    AtsApiService.get().getBranchService().setWorkingBranchCreationInProgress((IAtsTeamWorkflow)teamArt, false);
                } else if (branchEvent.getEventType() == BranchEventType.Committing) {
                    AtsApiService.get().getBranchService().setWorkingBranchCreationInProgress((IAtsTeamWorkflow)teamArt, true);
                } else if (branchEvent.getEventType() == BranchEventType.Committed || branchEvent.getEventType() == BranchEventType.CommitFailed) {
                    AtsApiService.get().getBranchService().setWorkingBranchCreationInProgress((IAtsTeamWorkflow)teamArt, false);
                }
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }
}

