/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile.navigate;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.agile.XOpenSprintReportsButton;
import org.eclipse.osee.ats.ide.agile.navigate.AgileNavigateItemProvider;
import org.eclipse.osee.ats.ide.agile.navigate.OpenAgileSprint;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.ArtifactLabelProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.ArtifactTreeContentProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeArtifactDialog;

public class OpenAgileSprintReports
extends XNavigateItemAction {
    public OpenAgileSprintReports() {
        super("Open Agile Sprint Reports", (OseeImage)AtsImage.REPORT, new XNavItemCat[]{AgileNavigateItemProvider.AGILE_REPORTS});
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        LinkedList<Artifact> activeTeams = new LinkedList<Artifact>();
        for (Artifact agTeam : ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)AtsArtifactTypes.AgileTeam, (BranchId)AtsApiService.get().getAtsBranch())) {
            if (!((Boolean)agTeam.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Active, (Object)true)).booleanValue()) continue;
            activeTeams.add(agTeam);
        }
        FilteredTreeArtifactDialog dialog = new FilteredTreeArtifactDialog(this.getName(), "Select Agile Team", activeTeams, (ITreeContentProvider)new ArtifactTreeContentProvider(), (ILabelProvider)new ArtifactLabelProvider());
        if (dialog.open() == 0) {
            Artifact agileTeamArt = dialog.getSelectedFirst();
            List sprints = Collections.castAll((Collection)AtsApiService.get().getRelationResolver().getRelated((ArtifactId)agileTeamArt, AtsRelationTypes.AgileTeamToSprint_Sprint));
            FilteredTreeArtifactDialog dialog2 = new FilteredTreeArtifactDialog(this.getName(), "Select Agile Team", (Collection)sprints, (ITreeContentProvider)new ArtifactTreeContentProvider(), (ILabelProvider)new OpenAgileSprint.SprintArtifactLabelProvider(), (ViewerComparator)new OpenAgileSprint.SprintStateTypeComparator());
            if (dialog2.open() == 0) {
                Collection selected = dialog2.getSelected();
                XOpenSprintReportsButton stored = new XOpenSprintReportsButton();
                stored.setArtifact((Artifact)selected.iterator().next());
                stored.openExternally();
            }
        }
    }
}

