/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile.navigate;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactImages;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.ide.AtsArtifactImageProvider;
import org.eclipse.osee.ats.ide.AtsOpenOption;
import org.eclipse.osee.ats.ide.agile.navigate.AgileNavigateItemProvider;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.workflow.sprint.SprintArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.ArtifactLabelProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.ArtifactTreeContentProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeArtifactDialog;

public class OpenAgileSprint
extends XNavigateItemAction {
    public OpenAgileSprint() {
        super("Open Agile Sprint", AtsArtifactImageProvider.getKeyedImage(AtsArtifactImages.AGILE_SPRINT), new XNavItemCat[]{AgileNavigateItemProvider.AGILE});
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        LinkedList<Artifact> activeTeams = new LinkedList<Artifact>();
        for (Artifact agTeam : ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)AtsArtifactTypes.AgileTeam, (BranchId)AtsApiService.get().getAtsBranch())) {
            if (!((Boolean)agTeam.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Active, (Object)true)).booleanValue()) continue;
            activeTeams.add(agTeam);
        }
        FilteredTreeArtifactDialog dialog = new FilteredTreeArtifactDialog(this.getName(), "Select Agile Team", activeTeams, (ITreeContentProvider)new ArtifactTreeContentProvider(), (ILabelProvider)new ArtifactLabelProvider());
        if (dialog.open() == 0) {
            Artifact agileTeamArt = dialog.getSelectedFirst();
            List sprints = Collections.castAll((Collection)AtsApiService.get().getRelationResolver().getRelated((ArtifactId)agileTeamArt, AtsRelationTypes.AgileTeamToSprint_Sprint));
            FilteredTreeArtifactDialog dialog2 = new FilteredTreeArtifactDialog(this.getName(), "Select Agile Team", (Collection)sprints, (ITreeContentProvider)new ArtifactTreeContentProvider(), (ILabelProvider)new SprintArtifactLabelProvider(), (ViewerComparator)new SprintStateTypeComparator());
            if (dialog2.open() == 0) {
                Collection selected = dialog2.getSelected();
                if (selected.size() == 1) {
                    AtsEditors.openATSAction((ArtifactToken)selected.iterator().next(), AtsOpenOption.OpenAll);
                } else {
                    AtsEditors.openInAtsWorldEditor("Sprints", selected);
                }
            }
        }
    }

    public static class SprintArtifactLabelProvider
    extends ArtifactLabelProvider {
        public String getText(Object element) {
            if (element instanceof IAtsWorkItem) {
                return String.format("%s %s", super.getText(element), ((IAtsWorkItem)element).isInWork() ? "" : " - (" + ((IAtsWorkItem)element).getStateMgr().getCurrentStateName() + ")");
            }
            return super.getText(element);
        }
    }

    public static class SprintStateTypeComparator
    extends ViewerComparator {
        public int compare(Viewer viewer, Object e1, Object e2) {
            StateType e2StateType;
            StateType e1StateType;
            if (e1 instanceof SprintArtifact && e2 instanceof SprintArtifact && (e1StateType = ((IAtsWorkItem)e1).getStateMgr().getStateType()) != (e2StateType = ((IAtsWorkItem)e2).getStateMgr().getStateType())) {
                if (e1StateType.isInWork()) {
                    return -1;
                }
                return 1;
            }
            return super.compare(viewer, (Object)e2.toString(), (Object)e1.toString());
        }
    }
}

