/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions.wizard;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.team.ChangeType;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.ide.AtsOpenOption;
import org.eclipse.osee.ats.ide.actions.wizard.NewActionWizard;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorSimpleProvider;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.logging.OseeLog;

public class NewActionJob
extends Job {
    private String title;
    private final String desc;
    private final ChangeType changeType;
    private final String priority;
    private final Date needByDate;
    private final boolean validationRequired;
    private final Set<IAtsActionableItem> actionableItems;
    private final NewActionWizard wizard;
    private final Collection<INewActionListener> newActionListeners;
    private boolean openOnComplete = true;
    private ActionResult result;

    public NewActionJob(String title, String desc, ChangeType changeType, String priority, Date needByDate, boolean validationRequired, Set<IAtsActionableItem> actionableItems, NewActionWizard wizard, Collection<INewActionListener> newActionListeners) {
        super("Creating New Action");
        this.title = title;
        this.desc = desc;
        this.changeType = changeType;
        this.priority = priority;
        this.needByDate = needByDate;
        this.validationRequired = validationRequired;
        this.actionableItems = actionableItems;
        this.wizard = wizard;
        this.newActionListeners = newActionListeners;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            try {
                if (this.actionableItems.isEmpty()) {
                    throw new OseeArgumentException("Actionable Items can not be empty for New Action", new Object[0]);
                }
                if ("tt".equals(this.title)) {
                    this.title = String.valueOf(this.title) + " " + AtsApiService.get().getRandomNum();
                }
                IAtsChangeSet changes = AtsApiService.get().createChangeSet("Create New Action");
                this.result = AtsApiService.get().getActionService().createAction(AtsApiService.get().getUserService().getCurrentUser(), this.title, this.desc, this.changeType, this.priority, this.validationRequired, this.needByDate, this.actionableItems, new Date(), AtsApiService.get().getUserService().getCurrentUser(), this.newActionListeners == null ? Collections.emptyList() : this.newActionListeners, changes);
                if (this.wizard != null) {
                    this.wizard.notifyAtsWizardItemExtensions(this.result, changes);
                }
                if (monitor != null) {
                    monitor.subTask("Persisting");
                }
                changes.execute();
                if (this.openOnComplete) {
                    if (this.result.getTeamWfs().size() == 1) {
                        AtsEditors.openATSAction(this.result.getFirstTeam().getStoreObject(), AtsOpenOption.OpenAll);
                    } else {
                        WorldEditor.open(new WorldEditorSimpleProvider("Workflows", this.result.getTeamWfArts()));
                    }
                }
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                Status status = new Status(4, "org.eclipse.osee.ats.ide", -1, ex.getMessage(), (Throwable)ex);
                if (monitor != null) {
                    monitor.done();
                }
                return status;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return Status.OK_STATUS;
    }

    public ActionResult getResults() {
        return this.result;
    }

    public boolean isOpenOnComplete() {
        return this.openOnComplete;
    }

    public void setOpenOnComplete(boolean openOnComplete) {
        this.openOnComplete = openOnComplete;
    }
}

