/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class OseeWebApplicationException
extends WebApplicationException {
    private static final long serialVersionUID = -1566145923396351675L;
    private final Response.StatusType errorStatus;
    private final String errorMessage;

    public OseeWebApplicationException(Response.Status status, String message, Object ... args) {
        this(null, (Response.StatusType)status, message, args);
    }

    public OseeWebApplicationException(Throwable cause, Response.StatusType status, String message, Object ... args) {
        super(cause, status.getStatusCode());
        this.errorStatus = status;
        this.errorMessage = message != null ? OseeWebApplicationException.formatMessage(message, args) : null;
    }

    public Response getResponse() {
        return Response.status((Response.StatusType)this.getErrorStatus()).entity((Object)this.errorMessage).header("osee-jaxrs-error-response", (Object)Boolean.TRUE).build();
    }

    public Response.StatusType getErrorStatus() {
        return this.errorStatus;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private static String formatMessage(String message, Object ... args) {
        String toReturn = message;
        if (args != null && args.length > 0) {
            try {
                toReturn = String.format(message, args);
            }
            catch (RuntimeException ex) {
                toReturn = String.format("Exception message could not be formatted: [%s] with the following arguments [%s].  Cause [%s]", message, Collections.toString((String)",", (Object[])args), ex.toString());
            }
        }
        return toReturn;
    }
}

