/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.recursive.comparison.ComparisonDifference;
import org.assertj.core.api.recursive.comparison.FieldLocation;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonDifferenceCalculator;
import org.assertj.core.error.ShouldBeEqualByComparingFieldByFieldRecursively;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.util.CheckReturnValue;

public class RecursiveComparisonAssert<SELF extends RecursiveComparisonAssert<SELF>>
extends AbstractAssert<SELF, Object> {
    private RecursiveComparisonConfiguration recursiveComparisonConfiguration;
    private RecursiveComparisonDifferenceCalculator recursiveComparisonDifferenceCalculator;

    public RecursiveComparisonAssert(Object actual, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        super(actual, RecursiveComparisonAssert.class);
        this.recursiveComparisonConfiguration = recursiveComparisonConfiguration;
        this.recursiveComparisonDifferenceCalculator = new RecursiveComparisonDifferenceCalculator();
        Failures.instance();
    }

    void setRecursiveComparisonConfiguration(RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        this.recursiveComparisonConfiguration = recursiveComparisonConfiguration;
    }

    @Override
    public SELF isEqualTo(Object expected) {
        if (this.actual == expected) {
            return (SELF)((RecursiveComparisonAssert)this.myself);
        }
        if (expected == null) {
            this.objects.assertNull(this.info, this.actual);
        }
        this.objects.assertNotNull(this.info, this.actual);
        List<ComparisonDifference> differences = this.determineDifferencesWith(expected);
        if (!differences.isEmpty()) {
            throw this.objects.getFailures().failure((AssertionInfo)this.info, ShouldBeEqualByComparingFieldByFieldRecursively.shouldBeEqualByComparingFieldByFieldRecursively(this.actual, expected, differences, this.recursiveComparisonConfiguration, this.info.representation()));
        }
        return (SELF)((RecursiveComparisonAssert)this.myself);
    }

    @CheckReturnValue
    public SELF ignoringActualNullFields() {
        this.recursiveComparisonConfiguration.setIgnoreAllActualNullFields(true);
        return (SELF)((RecursiveComparisonAssert)this.myself);
    }

    @CheckReturnValue
    public SELF ignoringFields(String ... fieldsToIgnore) {
        this.recursiveComparisonConfiguration.ignoreFields(fieldsToIgnore);
        return (SELF)((RecursiveComparisonAssert)this.myself);
    }

    @CheckReturnValue
    public SELF ignoringFieldsMatchingRegexes(String ... regexes) {
        this.recursiveComparisonConfiguration.ignoreFieldsMatchingRegexes(regexes);
        return (SELF)((RecursiveComparisonAssert)this.myself);
    }

    public SELF ignoringAllOverriddenEquals() {
        this.recursiveComparisonConfiguration.ignoreAllOverriddenEquals();
        return (SELF)((RecursiveComparisonAssert)this.myself);
    }

    @CheckReturnValue
    public SELF ignoringOverriddenEqualsForFields(String ... fields) {
        this.recursiveComparisonConfiguration.ignoreOverriddenEqualsForFields(fields);
        return (SELF)((RecursiveComparisonAssert)this.myself);
    }

    @CheckReturnValue
    public SELF ignoringOverriddenEqualsForTypes(Class<?> ... types) {
        this.recursiveComparisonConfiguration.ignoreOverriddenEqualsForTypes(types);
        return (SELF)((RecursiveComparisonAssert)this.myself);
    }

    @CheckReturnValue
    public SELF ignoringOverriddenEqualsForFieldsMatchingRegexes(String ... regexes) {
        this.recursiveComparisonConfiguration.ignoreOverriddenEqualsForFieldsMatchingRegexes(regexes);
        return (SELF)((RecursiveComparisonAssert)this.myself);
    }

    @CheckReturnValue
    public SELF ignoringCollectionOrder() {
        this.recursiveComparisonConfiguration.ignoreCollectionOrder(true);
        return (SELF)((RecursiveComparisonAssert)this.myself);
    }

    @CheckReturnValue
    public SELF ignoringCollectionOrderInFields(String ... fieldsToIgnoreCollectionOrder) {
        this.recursiveComparisonConfiguration.ignoreCollectionOrderInFields(fieldsToIgnoreCollectionOrder);
        return (SELF)((RecursiveComparisonAssert)this.myself);
    }

    @CheckReturnValue
    public SELF ignoringCollectionOrderInFieldsMatchingRegexes(String ... regexes) {
        this.recursiveComparisonConfiguration.ignoreCollectionOrderInFieldsMatchingRegexes(regexes);
        return (SELF)((RecursiveComparisonAssert)this.myself);
    }

    @CheckReturnValue
    public SELF withStrictTypeChecking() {
        this.recursiveComparisonConfiguration.strictTypeChecking(true);
        return (SELF)((RecursiveComparisonAssert)this.myself);
    }

    @CheckReturnValue
    public SELF withComparatorForFields(Comparator<?> comparator, String ... fieldLocations) {
        Stream.of(fieldLocations).map(FieldLocation::new).forEach(fieldLocation -> this.recursiveComparisonConfiguration.registerComparatorForField(comparator, (FieldLocation)fieldLocation));
        return (SELF)((RecursiveComparisonAssert)this.myself);
    }

    @CheckReturnValue
    public <T> SELF withComparatorForType(Comparator<? super T> comparator, Class<T> type) {
        this.recursiveComparisonConfiguration.registerComparatorForType(comparator, type);
        return (SELF)((RecursiveComparisonAssert)this.myself);
    }

    SELF withTypeComparators(TypeComparators typeComparators) {
        Optional.ofNullable(typeComparators).map(TypeComparators::comparatorByTypes).ifPresent(comparatorByTypes -> comparatorByTypes.forEach(this::registerComparatorForType));
        return (SELF)((RecursiveComparisonAssert)this.myself);
    }

    private void registerComparatorForType(Map.Entry<Class<?>, Comparator<?>> entry) {
        this.withComparatorForType(entry.getValue(), entry.getKey());
    }

    public RecursiveComparisonConfiguration getRecursiveComparisonConfiguration() {
        return this.recursiveComparisonConfiguration;
    }

    private List<ComparisonDifference> determineDifferencesWith(Object expected) {
        return this.recursiveComparisonDifferenceCalculator.determineDifferences(this.actual, expected, this.recursiveComparisonConfiguration);
    }
}

