/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.groups.RepositoryGroup;
import org.eclipse.egit.ui.internal.repository.RepositoryTreeNodeLabelProvider;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryGroupNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DeleteRepositoryGroupConfirmDialog
extends TitleAreaDialog {
    private List<RepositoryGroupNode> groupsToDelete;
    private boolean shouldShowAgain;
    private Button dontShowAgain;

    public DeleteRepositoryGroupConfirmDialog(Shell parentShell, List<RepositoryGroupNode> groupsToDelete) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.groupsToDelete = groupsToDelete;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.RepositoriesView_RepoGroup_Delete_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        main.setLayout((Layout)new GridLayout(1, false));
        TreeViewer groupsViewer = new TreeViewer(main, 2560);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(groupsViewer.getControl());
        groupsViewer.setLabelProvider((IBaseLabelProvider)new RepositoryTreeNodeLabelProvider(true));
        groupsViewer.setContentProvider((IContentProvider)new DeleteRepositoryGroupTreeContentProvider());
        groupsViewer.setInput(this.groupsToDelete);
        this.dontShowAgain = new Button(main, 32);
        this.dontShowAgain.setText(UIText.RepositoriesView_RepoGroup_DeleteDontShowAgain);
        this.setTitle(UIText.RepositoriesView_RepoGroup_Delete_Title);
        this.setMessage(UIText.RepositoriesView_RepoGroup_Delete_Confirm);
        return main;
    }

    protected void okPressed() {
        this.shouldShowAgain = !this.dontShowAgain.getSelection();
        super.okPressed();
    }

    public boolean showAgain() {
        return this.shouldShowAgain;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, UIText.DeleteRepositoryConfirmDialog_DeleteRepositoryConfirmButton, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private static class DeleteRepositoryGroupTreeContentProvider
    implements ITreeContentProvider {
        private List<RepositoryGroupNode> groupsToDelete;

        private DeleteRepositoryGroupTreeContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.groupsToDelete = (List)newInput;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof RepositoryGroupNode) {
                return !((RepositoryGroup)((RepositoryGroupNode)element).getObject()).getRepositoryDirectories().isEmpty();
            }
            return false;
        }

        public Object getParent(Object element) {
            return ((RepositoryTreeNode)element).getParent();
        }

        public Object[] getElements(Object inputElement) {
            return this.groupsToDelete.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof RepositoryGroupNode) {
                RepositoryCache cache = Activator.getDefault().getRepositoryCache();
                RepositoryGroupNode groupNode = (RepositoryGroupNode)parentElement;
                ArrayList result = new ArrayList();
                ((RepositoryGroup)groupNode.getObject()).getRepositoryDirectories().stream().forEach(repoDir -> {
                    try {
                        result.add(new RepositoryNode(groupNode, cache.lookupRepository(repoDir)));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
                return result.toArray();
            }
            return null;
        }
    }
}

