/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging.event.res.internal;

import java.rmi.RemoteException;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.osee.framework.messaging.OseeMessagingListener;
import org.eclipse.osee.framework.messaging.ReplyConnection;
import org.eclipse.osee.framework.messaging.event.res.IFrameworkEventListener;
import org.eclipse.osee.framework.messaging.event.res.RemoteEvent;

public class FrameworkRelayMessagingListener<T extends RemoteEvent>
extends OseeMessagingListener {
    private final IFrameworkEventListener frameworkEventListener;
    private final boolean isVerbose;

    protected FrameworkRelayMessagingListener(Class<?> clazz, IFrameworkEventListener frameworkEventListener, boolean isVerbose) {
        super(clazz);
        this.frameworkEventListener = frameworkEventListener;
        this.isVerbose = isVerbose;
    }

    public void process(Object message, Map<String, Object> headers, ReplyConnection replyConnection) {
        if (this.isVerbose) {
            XConsoleLogger.err((String)String.format(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " - received [%s]", message.getClass().getSimpleName()), (Object[])new Object[0]);
        }
        try {
            T remoteEvent = this.asCastedMessage(message);
            this.frameworkEventListener.onEvent((RemoteEvent)remoteEvent);
        }
        catch (RemoteException ex) {
            XConsoleLogger.err((String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " - process: " + ex.getLocalizedMessage()), (Object[])new Object[0]);
        }
    }

    private T asCastedMessage(Object message) {
        return (T)((RemoteEvent)message);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.frameworkEventListener == null ? 0 : this.frameworkEventListener.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FrameworkRelayMessagingListener other = (FrameworkRelayMessagingListener)((Object)obj);
        return !(this.frameworkEventListener == null ? other.frameworkEventListener != null : !this.frameworkEventListener.equals(other.frameworkEventListener));
    }
}

