/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.util.internal;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.xviewer.Activator;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.core.util.XmlUtil;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLog;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerWidgetModifiedListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class XViewerWidget {
    protected Label labelWidget = null;
    protected String label = "";
    protected String xmlRoot = "";
    protected String xmlSubRoot = "";
    protected String toolTip = null;
    protected boolean requiredEntry = false;
    protected boolean editable = true;
    protected boolean verticalLabel = false;
    protected boolean fillVertically = false;
    protected boolean fillHorizontally = false;
    protected boolean displayLabel = true;
    private final Set<XViewerWidgetModifiedListener> modifiedListeners = new LinkedHashSet<XViewerWidgetModifiedListener>();
    private MouseListener mouseLabelListener;
    public static final int RPT_NONE = 0;
    public static final int RPT_SINGLE_LINE = 1;
    public static final int RPT_MULTI_LINE = 2;
    protected int reportType = 1;
    protected FormToolkit toolkit;

    public boolean isFillHorizontally() {
        return this.fillHorizontally;
    }

    public XViewerWidget(String label) {
        this.label = label;
    }

    public XViewerWidget(String label, String xmlRoot) {
        this.label = label;
        this.xmlRoot = xmlRoot;
    }

    public XViewerWidget(String label, String xmlRoot, String xmlSubRoot) {
        this.label = label;
        this.xmlRoot = xmlRoot;
        this.xmlSubRoot = xmlSubRoot;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
        if (this.labelWidget != null && !this.labelWidget.isDisposed()) {
            this.labelWidget.setToolTipText(toolTip);
        }
    }

    public void addXModifiedListener(XViewerWidgetModifiedListener listener) {
        this.modifiedListeners.add(listener);
    }

    public void notifyXModifiedListeners() {
        for (XViewerWidgetModifiedListener listener : this.modifiedListeners) {
            listener.widgetModified(this);
        }
    }

    public void setLabelError() {
        if (this.labelWidget == null || this.labelWidget.isDisposed()) {
            return;
        }
        if (!this.isValid()) {
            this.labelWidget.setForeground(Display.getCurrent().getSystemColor(3));
        } else {
            this.labelWidget.setForeground(null);
        }
        if (this.mouseLabelListener == null) {
            this.mouseLabelListener = new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                    XViewerWidget.this.openHelp();
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                }
            };
            this.labelWidget.addMouseListener(this.mouseLabelListener);
        }
    }

    public abstract Control getControl();

    public void openHelp() {
        try {
            if (this.toolTip != null && this.label != null) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)(String.valueOf(this.label) + " " + XViewerText.get("tooltip")), (String)this.toolTip);
            }
        }
        catch (Exception ex) {
            XViewerLog.log(Activator.class, Level.SEVERE, ex);
        }
    }

    public abstract void createWidgets(Composite var1, int var2);

    public void createWidgets(FormToolkit toolkit, Composite parent, int horizontalSpan) {
        this.toolkit = toolkit;
        this.createWidgets(parent, horizontalSpan);
        this.adaptControls(toolkit);
    }

    public void adaptControls(FormToolkit toolkit) {
        if (this.getControl() != null) {
            toolkit.adapt(this.getControl(), true, true);
        }
        if (this.labelWidget != null) {
            toolkit.adapt((Control)this.labelWidget, true, true);
            toolkit.adapt((Control)this.labelWidget.getParent(), true, true);
        }
    }

    public abstract void dispose();

    public abstract void setFocus();

    public abstract void refresh();

    public abstract boolean isValid();

    public abstract void setXmlData(String var1);

    public abstract String getXmlData();

    public abstract String toHTML(String var1);

    public String toXml() throws Exception {
        if (this.xmlSubRoot.equals("")) {
            return this.toXml(this.xmlRoot);
        }
        return this.toXml(this.xmlRoot, this.xmlSubRoot);
    }

    public String toXml(String xmlRoot) throws Exception {
        return "<" + xmlRoot + ">" + XmlUtil.textToXml((String)this.getXmlData()) + "</" + xmlRoot + ">\n";
    }

    public String toXml(String xmlRoot, String xmlSubRoot) throws Exception {
        return "<" + xmlRoot + ">" + "<" + xmlSubRoot + ">" + XmlUtil.textToXml((String)this.getXmlData()) + "</" + xmlSubRoot + ">" + "</" + xmlRoot + ">\n";
    }

    public void setFromXml(String xml) throws IllegalStateException {
        Matcher m = Pattern.compile("<" + this.xmlRoot + ">(.*?)</" + this.xmlRoot + ">", 40).matcher(xml);
        if (m.find()) {
            this.setXmlData(XmlUtil.xmlToText((String)m.group(1)));
        }
    }

    public List<String> getDisplayLabels() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.label);
        return l;
    }

    public void setDisplayLabel(String displayLabel) {
        this.label = displayLabel;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isVerticalLabel() {
        return this.verticalLabel;
    }

    public void setVerticalLabel(boolean verticalLabel) {
        this.verticalLabel = verticalLabel;
    }

    public String getXmlRoot() {
        return this.xmlRoot;
    }

    public void setXmlRoot(String xmlRoot) {
        this.xmlRoot = xmlRoot;
    }

    public String getXmlSubRoot() {
        return this.xmlSubRoot;
    }

    public void setXmlSubRoot(String xmlSubRoot) {
        this.xmlSubRoot = xmlSubRoot;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public boolean isFillVertically() {
        return this.fillVertically;
    }

    public void setFillVertically(boolean fillVertically) {
        this.fillVertically = fillVertically;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Label getLabelWidget() {
        return this.labelWidget;
    }

    public void setLabelWidget(Label labelWidget) {
        this.labelWidget = labelWidget;
    }

    public boolean isRequiredEntry() {
        return this.requiredEntry;
    }

    public void setRequiredEntry(boolean requiredEntry) {
        this.requiredEntry = requiredEntry;
    }

    public int getReportType() {
        return this.reportType;
    }

    public void setReportType(int reportType) {
        this.reportType = reportType;
    }

    public abstract String getReportData();

    public String toString() {
        return this.toReport();
    }

    public String toReport() {
        return this.toReport(this.reportType);
    }

    public String toReport(int rptType) {
        String s = String.valueOf(this.label) + ": ";
        switch (rptType) {
            case 1: {
                s = String.valueOf(s) + this.getReportData() + "\n\n";
                break;
            }
            case 2: {
                String data = this.getReportData();
                data = data.replaceAll("\n", "\n   ");
                s = String.valueOf(s) + "\n" + data + "\n\n";
                break;
            }
            default: {
                s = String.valueOf(s) + this.getReportData();
            }
        }
        return s;
    }

    public void setDisplayLabel(boolean displayLabel) {
        this.displayLabel = displayLabel;
    }

    public void setFillHorizontally(boolean fillHorizontally) {
        this.fillHorizontally = fillHorizontally;
    }

    public abstract Object getData();

    public boolean isDisplayLabel() {
        return this.displayLabel;
    }
}

