/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal.dbsupport.hsql;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.osee.jdbc.JdbcLogger;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.server.Server;

public final class HsqlServerDelegate {
    private static final String sc_key_remote_open_db = "server.remote_open";
    private final String dbHost;
    private final int dbPort;
    private final String dbPath;
    private final String dbName;
    private final Properties dbProperties;
    private final AtomicBoolean wasStarted = new AtomicBoolean();
    private Server server;
    private Thread hook;

    public HsqlServerDelegate(String dbHost, int dbPort, String dbPath, String dbName, Properties dbProperties) {
        this.dbHost = dbHost;
        this.dbPort = dbPort;
        this.dbPath = dbPath;
        this.dbName = dbName;
        this.dbProperties = dbProperties;
    }

    public void start(final JdbcLogger logger) throws Exception {
        if (!this.wasStarted.getAndSet(true)) {
            this.server = new Server();
            this.server.setErrWriter(HsqlServerDelegate.newErrorWriter(logger));
            this.server.setLogWriter(HsqlServerDelegate.newDebugWriter(logger));
            InetAddress address = InetAddress.getByName(this.dbHost);
            this.server.setAddress(address.getHostAddress());
            this.server.setPort(this.dbPort);
            StringBuilder dbCreationUrl = new StringBuilder();
            dbCreationUrl.append(this.dbPath);
            this.appendProperties(dbCreationUrl, this.dbProperties);
            this.server.setDatabaseName(0, this.dbName);
            this.server.setDatabasePath(0, dbCreationUrl.toString());
            HsqlProperties props = new HsqlProperties();
            props.setProperty(sc_key_remote_open_db, true);
            this.server.setProperties(props);
            this.server.start();
            this.hook = new Thread(){

                @Override
                public void run() {
                    try {
                        HsqlServerDelegate.this.shutdown(logger);
                    }
                    catch (Exception exception) {}
                }
            };
            Runtime.getRuntime().addShutdownHook(this.hook);
        }
    }

    private void appendProperties(StringBuilder builder, Properties props) {
        if (!props.isEmpty()) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                builder.append(String.format(";%s=%s", entry.getKey(), entry.getValue()));
            }
        }
    }

    public void shutdown(JdbcLogger logger) {
        block7: {
            if (this.wasStarted.getAndSet(false)) {
                if (this.hook != null) {
                    try {
                        Runtime.getRuntime().removeShutdownHook(this.hook);
                    }
                    catch (Exception exception) {}
                }
                if (this.server != null) {
                    try {
                        this.server.shutdownWithCatalogs(2);
                    }
                    catch (Exception ex) {
                        if (logger == null) break block7;
                        logger.error(ex, "Error during shutdown", new Object[0]);
                    }
                }
            }
        }
    }

    public void printInfo(JdbcLogger logger) {
        if (logger != null) {
            if (this.server != null) {
                try {
                    StringBuilder builder = new StringBuilder();
                    builder.append("HyperSQL Database: ");
                    builder.append("\n\tAddress : ");
                    builder.append(this.server.getAddress());
                    builder.append("\n\tDatabase Name : ");
                    builder.append(this.server.getDatabaseName(0, true));
                    builder.append("\n\tDatabasePath : ");
                    builder.append(this.server.getDatabasePath(0, true));
                    builder.append("\n\tPort : ");
                    builder.append(this.server.getPort());
                    builder.append("\n\tDefaultWebPage : ");
                    builder.append(this.server.getDefaultWebPage());
                    builder.append("\n\tProductName : ");
                    builder.append(this.server.getProductName());
                    builder.append("\n\tProductVersion : ");
                    builder.append(this.server.getProductVersion());
                    builder.append("\n\tProtocol : ");
                    builder.append(this.server.getProtocol());
                    builder.append("\n\tServerId : ");
                    builder.append(this.server.getServerId());
                    builder.append("\n\tState : ");
                    builder.append(this.server.getState());
                    builder.append("\n\tStateDescriptor : ");
                    builder.append(this.server.getStateDescriptor());
                    builder.append("\n\tWebRoot : ");
                    builder.append(this.server.getWebRoot());
                    logger.info(builder.toString(), new Object[0]);
                }
                catch (Exception ex) {
                    logger.error(ex, "Error getting Server Information", new Object[0]);
                }
            } else {
                logger.info("Server was not started", new Object[0]);
            }
        }
    }

    public boolean isAlive(long waitTimeMillis) {
        boolean result = false;
        if (this.server != null) {
            try {
                if (waitTimeMillis > 0L) {
                    int totalWaitTime = 0;
                    while ((long)totalWaitTime < waitTimeMillis && !result) {
                        try {
                            this.server.checkRunning(true);
                            result = true;
                        }
                        catch (Exception exception) {
                            try {
                                if ((long)totalWaitTime >= waitTimeMillis) continue;
                                Thread.sleep(100L);
                                totalWaitTime += 100;
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private static PrintWriter newErrorWriter(JdbcLogger logger) {
        LogPrintWriter toReturn = null;
        if (logger != null) {
            toReturn = new LogPrintWriter(logger, true);
        }
        return toReturn;
    }

    private static PrintWriter newDebugWriter(JdbcLogger logger) {
        LogPrintWriter toReturn = null;
        if (logger != null) {
            toReturn = new LogPrintWriter(logger, false);
        }
        return toReturn;
    }

    private static class LogPrintWriter
    extends PrintWriter {
        private final StringBuilder builder = new StringBuilder();
        private final JdbcLogger log;
        private final boolean logToError;

        public LogPrintWriter(JdbcLogger log, boolean logToError) {
            super(new NoOpWriter());
            this.log = log;
            this.logToError = logToError;
        }

        @Override
        public void close() {
            this.flushBuffer();
            super.close();
        }

        @Override
        public void flush() {
            this.flushBuffer();
            super.flush();
        }

        @Override
        public void write(int c) {
            this.builder.append(c);
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            this.builder.append(cbuf, off, len);
        }

        @Override
        public void write(String str, int off, int len) {
            this.builder.append(str.substring(off, off + len));
        }

        @Override
        public void println() {
            if (this.log == null) {
                this.builder.append('\n');
            }
            this.flushBuffer();
        }

        private void flushBuffer() {
            if (this.builder.length() == 0) {
                return;
            }
            if (this.log != null) {
                if (this.logToError) {
                    this.log.error(this.builder.toString(), new Object[0]);
                } else {
                    this.log.debug(this.builder.toString(), new Object[0]);
                }
            } else {
                try {
                    this.out.write(this.builder.toString());
                }
                catch (IOException iOException) {
                    this.setError();
                }
            }
            this.builder.setLength(0);
        }

        private static class NoOpWriter
        extends Writer {
            private NoOpWriter() {
            }

            @Override
            public void close() {
            }

            @Override
            public void flush() {
            }

            @Override
            public void write(char[] cbuf, int off, int len) {
            }
        }
    }
}

