/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal.dbsupport.hsql;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.osee.jdbc.JdbcLogger;
import org.eclipse.osee.jdbc.JdbcServer;
import org.eclipse.osee.jdbc.JdbcServerConfig;
import org.eclipse.osee.jdbc.internal.dbsupport.hsql.HsqlServerDelegate;

public final class HsqlJdbcServer
implements JdbcServer {
    private final JdbcLogger logger;
    private final JdbcServerConfig config;
    private final AtomicReference<HsqlServerDelegate> serverRef = new AtomicReference();
    private final AtomicBoolean wasStarted = new AtomicBoolean(false);

    public HsqlJdbcServer(JdbcLogger logger, JdbcServerConfig config) {
        this.logger = logger;
        this.config = config;
    }

    @Override
    public void start() {
        if (!this.wasStarted.getAndSet(true)) {
            Properties properties;
            String dbName;
            String path;
            int port;
            String host = this.config.getDbHost();
            HsqlServerDelegate oldInfo = this.serverRef.getAndSet(new HsqlServerDelegate(host, port = this.config.getDbPort(), path = this.config.getDbPath(), dbName = this.config.getDbName(), properties = this.config.getProperties()));
            if (oldInfo != null) {
                oldInfo.shutdown(this.logger);
            }
            HsqlServerDelegate server = this.serverRef.get();
            this.logInfo("Starting Hsql Database Server on [%s:%s]....", host, port, host);
            try {
                server.start(this.logger);
                if (this.isAlive(this.config.getStartUpWaitTimeout())) {
                    server.printInfo(this.logger);
                } else {
                    this.logInfo("Exiting, since unable to connect to Hsql Database Server.", new Object[0]);
                    this.logInfo("Please try to increase the amount of time to keep trying to connect to the Server.", new Object[0]);
                }
            }
            catch (Exception ex) {
                this.logError(ex, "Error starting Hsql server", new Object[0]);
            }
        }
    }

    @Override
    public void stop() {
        HsqlServerDelegate server;
        if (this.wasStarted.getAndSet(false) && (server = (HsqlServerDelegate)this.serverRef.getAndSet(null)) != null) {
            server.shutdown(this.logger);
        }
    }

    @Override
    public boolean isAlive() {
        return this.isAlive(this.config.getAliveWaitTimeout());
    }

    @Override
    public boolean isAlive(long waitTime) {
        boolean result = false;
        HsqlServerDelegate server = this.serverRef.get();
        if (server != null) {
            result = server.isAlive(waitTime);
        }
        return result;
    }

    @Override
    public JdbcServerConfig getConfig() {
        return this.config;
    }

    private void logInfo(String msg, Object ... data) {
        if (this.logger != null) {
            this.logger.info(msg, data);
        }
    }

    private void logError(Exception ex, String msg, Object ... data) {
        if (this.logger != null) {
            this.logger.error(ex, msg, data);
        }
    }
}

